<?php

extract( shortcode_atts( array(
	'style' => '',
	'type' => '', // maybe for future version
	'count' => '10',
	'group_by' => '',
	'categories' => false,
	'color_scheme' => '',
	'el_class' => '',
), $atts ) );

$css_class = array( 'sm-timeline', 'sm_content_element', 'clearfix' );
$style = sm_validate_with_array( $style, sm_get_timeline_post_styles_array() );
$css_class[] = $style;
$color_scheme = sm_validate_with_array( $color_scheme, sm_get_timeline_color_schemes_array() );
if ( !empty( $color_scheme ) ) $css_class[] = $color_scheme;
$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );
$group_by = sm_validate_with_array( $group_by, sm_get_timeline_group_by_array() );

$timeline_data = sm_get_timeline_data_from_posts( $count, $group_by, $categories );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php if ( 'sm-style-speech-bubble' == $style ) : ?>
	<?php foreach( $timeline_data as $group ) : ?>
		<div class="timeline-element date-separator">
			<div class="timeline-spine"></div>
			<div class="date-wrap"><span><?php echo esc_html( $group['group_label']); ?></span></div>
		</div>
		<div class="first-margin">
		</div>
		<?php
		if ( !empty( $group['contents'] ) ) :
			$side = 1;
			foreach( $group['contents'] as $data ): 
			?>
			<div class="timeline-element <?php echo ( $side < 0 ? 'left-side': 'right-side' ); ?>">
				<div class="timeline-spine"></div>
				<div class="timeline-element-inner">
					<a href="<?php echo esc_url( $data['url'] ); ?>">
						<div class="anchor-point"></div>
						<div class="animation-wrap">
							<div class="te-content-wrap">
								<div class="te-date"><?php echo esc_html( $data['date'] ); ?></div>
								<h3 class="te-title"><?php echo esc_html( $data['title'] ); ?></h3>
								<div class="te-content"><?php echo sm_do_kses( $data['content'] ); ?></div>
							</div>
							<div class="te-angle-border">
								<div class="border-part-top"></div>
								<div class="angle-part"></div>
								<div class="border-part-bottom"></div>
							</div>
						</div>
					</a>
				</div>
			</div>
			<?php 
				$side = - $side;
			endforeach;
		endif;
		?>
	<?php endforeach; ?>
<?php elseif ( 'sm-style-grid-item' == $style ) : ?>

	<?php foreach( $timeline_data as $group ) : ?>
		<div class="timeline-element date-separator">
			<div class="timeline-spine"></div>
			<div class="date-wrap"><span><?php echo esc_html( $group['group_label']); ?></span></div>
		</div>
		<div class="first-margin">
		</div>
		<?php
		if ( !empty( $group['contents'] ) ) :
			$side = 1;
			foreach( $group['contents'] as $data ): 
			?>
			<div class="timeline-element <?php echo ( $side < 0 ? 'left-side': 'right-side' ); ?>">
				<div class="timeline-spine"></div>
				<div class="timeline-element-inner">
					<div class="anchor-point"></div>
					<div class="animation-wrap grid-item-wrap">
					<?php 
						global $post;
						$post = $data['post'];
						setup_postdata( $post );
						get_template_part( 'templates/blog/grid/content', get_post_format( $post->ID ) );
						wp_reset_postdata();
					?>
					</div>
				</div>
			</div>
			<?php 
				$side = - $side;
			endforeach;
		endif;
		?>
	<?php endforeach; ?>
<?php endif; ?>
</div>