<?php
extract( shortcode_atts( array(
	'name' => '',
	'avatar' => '',
	'company' => '',
	'el_class' => '',
), $atts ) );

$css_class = array( 'sm-testimonial-item', 'clearfix' );
$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$avatar_url = wp_get_attachment_url( $avatar );
$style = $GLOBALS['sm-testimonials-style'];

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

$content = preg_replace( '/<\/?p\>/', '', $content );

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php if ( 'sm-style1' == $style ) : ?>
	<div class="ts-info">
		<div class="avatar-wrap">
			<div class="avatar-inner">
				<div class="img" style="background: url(<?php echo esc_attr( $avatar_url ); ?>) no-repeat center center; background-size: cover;"></div>
			</div>
		</div>
		<div class="ts-name"><?php echo esc_html( $name ); ?></div>
		<div class="ts-company"><?php echo esc_html( $company ); ?></div>
	</div>
	<div class="ts-content">
		<div class="content-wrap">
			<div class="ts-angle"></div>
			<div class="content-inner">
				<?php echo sm_do_kses( $content ); ?>
			</div>
		</div>
	</div>
<?php elseif ( 'sm-style2' == $style ) : ?>
	<div class="ts-info">
		<div class="avatar-wrap">
			<div class="avatar-inner">
				<div class="img" style="background: url(<?php echo esc_attr( $avatar_url ); ?>) no-repeat center center; background-size: cover;"></div>
			</div>
		</div>
		<div class="ts-name"><?php echo esc_html( $name ); ?></div>
		<div class="ts-company"><?php echo esc_html( $company ); ?></div>
	</div>
	<div class="ts-content">
		<div class="content-wrap">
			<div class="ts-angle"></div>
			<div class="content-inner">
				<?php echo sm_do_kses( $content ); ?>
			</div>
		</div>
	</div>
<?php elseif ( 'sm-style3' == $style ) : ?>
	<div class="ts-wrap">
		<div class="ts-content">
			<?php echo sm_do_kses( $content ); ?>
		</div>
		<div class="ts-info">
			<span class="ts-name"><?php echo esc_html( $name ); ?></span> - <span class="ts-company"><?php echo esc_html( $company ); ?></span>
		</div>
	</div>
	<div class="avatar-wrap">
		<div class="avatar-inner">
		<?php if ( !empty( $avatar_url ) ) : ?>
			<img src="<?php echo esc_url( $avatar_url ); ?>" alt="<?php echo esc_attr( $name ); ?>" />
		<?php endif; ?>
		</div>
	</div>
<?php elseif ( 'sm-style4' == $style ) : ?>
	<div class="avatar-wrap">
		<div class="avatar-inner">
			<div class="img" style="background: url(<?php echo esc_attr( $avatar_url ); ?>) no-repeat center center; background-size: cover;"></div>
		</div>
	</div>
	<div class="ts-content">
		<?php echo sm_do_kses( $content ); ?>
	</div>
	<div class="ts-name"><?php echo esc_html( $name ); ?></div>
	<div class="ts-company"><?php echo esc_html( $company ); ?></div>
<?php elseif ( 'sm-style5' == $style ) : ?>
	<div class="ts-item-wrap">
		<div class="avatar-wrap">
			<div class="img" style="background: url(<?php echo esc_attr( $avatar_url ); ?>) no-repeat center center; background-size: cover;"></div>
		</div>
		<div class="ts-content">
			<?php echo sm_do_kses( $content ); ?>
			<div class="ts-info">
			<span class="ts-name"><?php echo esc_html( $name ); ?></span><?php if ( !empty( $company ) ) : ?> - <span class="ts-company"><?php echo esc_html( $company ); ?></span><?php endif; ?>
		</div>
		</div>
	</div>
<?php endif; ?>
</div>