<?php
$predefined_atts = array(
	'tab_id' => esc_html__( 'Tab', 'semona-extension' ),
	'title' => ''
);
$output = $title = $tab_id = '';
extract( shortcode_atts( $predefined_atts, $atts ) );

$css_class = 'sm_tab ui-tabs-panel sm_ui-tabs-hide clearfix';

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="tab-' . ( empty( $tab_id ) ? sanitize_title( $title ) : $tab_id ) . '"';
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php
	if ( $content == '' || $content == ' ' ) :
		echo esc_html__( 'Empty tab. Edit page to add content here.', 'semona-extension' );
	else:
		echo sm_js_remove_wpautop( $content, true );
	endif; ?>
</div>
