<?php
extract( shortcode_atts( array(
	'style' => '',
	'theme' => '',
	'content_fontsize' => '',
	'el_class' => '',
), $atts ) );

$css_class = array( 'sm-quotes-slider', 'sm_content_element', 'clearfix' );
$style = sm_validate_with_array( $style, sm_get_quotes_style_array() );
$css_class[] = $style;

$theme = sm_validate_with_array( $theme, sm_get_skins_array( true ) );
$css_class[] = $theme;

$id = sm_shortcode_unique_id( 'sm-quotes-slider' );
$css_gen = new Inline_CSS_Generator( "sm-quotes-slider", $id );
$scoped_css = '';

$content_fontsize = sm_validate_with_array( $content_fontsize, sm_get_quote_font_sizes_array() );
if ( !empty( $content_fontsize ) ) {
	$scoped_css .= $css_gen->css( '.quote-content', array( 'font-size' => $content_fontsize ) );
}
$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

$GLOBALS['sm-quotes-slider-style'] = $style;
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="quotes-wrap">
		<?php echo sm_js_remove_wpautop( $content, true ); ?>
	</div>
	<div class="quotes-nav">
	</div>
</div>