<?php

extract( shortcode_atts( array(
	'items_to_show' => '',
	'items_in_screen' => '5',
	'categories' => false,
	'el_class' => '',
), $atts ) );

$query_args = array();
$query_args['post_type'] = 'crf_portfolio';
if( $items_to_show ) {
	$query_args['posts_per_page'] = $items_to_show;
}
$query_args['post_status'] = array( 'publish', 'private' );
$query_args['has_password'] = false;
$query_args['ignore_sticky_posts'] = true;
if( $categories ) {
	$query_args['tax_query'] = array(
			array(
					'taxonomy' 	=> 'portfolio_category',
					'terms' 	=> explode( ',', $categories ),
			)
	);
}
$query = new WP_Query( $query_args );

if( !$items_in_screen ) {
	$items_in_screen = 5;
}

echo '<div class="sm-portfolio-carousel sm_content_element">';

if( $query->have_posts() ) {
	echo '<div class="sm-carousel" data-items="' . intval( $items_in_screen ) . '" data-prev=".sm-portfolio-carousel .control.prev" data-next=".sm-portfolio-carousel .control.next">';
	while( $query->have_posts() ): $query->the_post();
		echo '<div class="carousel-item">';
		get_template_part( 'templates/portfolio/grid/content' );
		echo '</div>';
	endwhile;
	echo '</div>';
	
	echo '<div class="controls">';
	echo '<a href="#" class="control prev"><i class="fa fa-angle-left"></i></a>';
	echo '<span class="control-sep"></span>';
	echo '<a href="#" class="control next"><i class="fa fa-angle-right"></i></a>';
	echo '</div>';
}

echo '</div>';