<?php
extract( shortcode_atts( array(
	'images' => '',
	'full_screen' => '',
	'height' => '500',
	'is_parallax_content' => '',
	'el_class' => '', 
), $atts ) );


$id = sm_shortcode_unique_id( "sm-parallax-layers" );
$css_gen = new Inline_CSS_Generator( "sm-parallax-layers", $id );
$scoped_css = '';


$css_class = array( 'sm-parallax-layers', 'sm_content_element', 'clearfix' );

if ( 'yes' == $full_screen ) {
	$css_class[] = 'full_screen_height';
}

if ( !empty( $images ) ) {
	$p_img_ids_array = explode( ',', $images );
}


$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
if ( $height !== '' && 'no' == $full_screen ) {
	//$scoped_css .= $css_gen->css( '', array( 'height' => $height . 'px' ) );
	$wrapper_attributes[] = 'data-height="' . $height . '"';
	$wrapper_attributes[] = 'style="height' . $height . 'px"';
}
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="sm-parallax-layers-wrap preload_parallax_layers<?php if ( 'yes' == $is_parallax_content ): ?> content_parallax<?php endif; ?>">
	<?php
	if ( !empty( $p_img_ids_array ) ) :
		foreach ( $p_img_ids_array as $p_img_id ) :
			$p_img_src = wp_get_attachment_image_src( $p_img_id, 'full', true );
			if ( $p_img_src !== false ) :
				$p_img_alt = get_post_meta( $p_img_id, '_wp_attachment_image_alt', true );
				$p_img_src = $p_img_src[0];
	?>
				<div class="image" style="background-image:url('<?php echo esc_url( $p_img_src ); ?>');"></div>
	<?php
			endif;
		endforeach;
	endif;
	if ( !empty( $content ) ) :
	?>
		<div class="parallax_layers_content_wrap">
			<div class="parallax_layers_content">
				<div class="parallax_layers_content_inner">
					<div class="container_inner">
						<?php echo do_shortcode( $content ); ?>
					</div>
				</div>
			</div>
		</div>
	<?php
	endif;
	?>
	</div>
</div>
