<?php
extract ( shortcode_atts ( array (
	'image' => '',
	'number' => '',
	'bg_color' => '',
	'custom_bg_color' => '',
	'border_color' => '',
	'custom_border_color' =>'',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '', 
), $atts ) );

$id = sm_shortcode_unique_id( "sm_numbered_thumbnail" );
$css_gen = new Inline_CSS_Generator( "sm-numbered-thumbnail", $id );

$css_class = array( 'sm-numbered-thumbnail', 'sm_content_element', 'clearfix' );
$bg_color = sm_validate_with_array( $bg_color, sm_get_preset_colors_array( false ) );
$scoped_css = '';
$custom_colors = array();
	
if ( 'custom' == $bg_color ) {
	if ( !empty( $custom_bg_color ) ) {
		$custom_colors['background-color'] = $custom_bg_color;
	}
} else {
	$css_class[] = $bg_color;
}

if ( 'custom' == $border_color ) {
	if ( !empty( $custom_border_color ) ) {
		$custom_colors['border-color'] = $custom_border_color;
	}
} else {
	$css_class[] = $border_color . '-border';
}
if ( !empty( $custom_colors ) ) {
	$scoped_css .= $css_gen->css( '.nt-number', $custom_colors );
}
$image_url = wp_get_attachment_url( $image );
if ( $image_url !== false )
	$image_url = 'url(' . $image_url . ') center center/cover no-repeat';
$lightbox_image_url = $image_url;

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="nt-image" style="background: <?php echo esc_attr( $image_url ); ?>"></div>
	<div class="nt-number"><?php echo esc_html( $number ); ?></div>
</div>
