<?php
extract ( shortcode_atts ( array (
	'type' => '',
	'icon_style' => '',
	'count' => 1,
	'twitter_id' => '',
	'consumer_key' => '',
	'consumer_secret' => '',
	'access_token' => '',
	'access_token_secret' => '',
	'bullet_shape' => '',
	'color' => '',
	'el_class' => '', 
), $atts ) );

$type = sm_validate_with_array( $type, sm_get_tweet_types_array() );
$icon_style = sm_validate_with_array( $icon_style, sm_get_tweet_icon_styles_array() );

$css_class = array( 'sm-latest-tweet', 'sm_content_element', 'clearfix' );

$css_class[] = $type;
if ( !empty( $icon_style ) ) $css_class[] = $icon_style;

$bullet_shape = sm_validate_with_array( $bullet_shape, sm_get_nav_bullet_shapes_array() );

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$tweets = false;
if ($twitter_id && $consumer_key && $consumer_secret && $access_token && $access_token_secret ) {

	$transName = 'sm_latest_tweets-' . substr( $twitter_id, 0, 25 ) . '-' . $count;
	$cacheTime = 10;
	if (false === ($twitterData = get_transient( $transName ))) {
		$twitterConnection = new TwitterOAuth( $consumer_key, $consumer_secret, $access_token, $access_token_secret );
		$twitterData = $twitterConnection->get( 'statuses/user_timeline', array(
			'screen_name'     => $twitter_id,
			'count'           => $count,
			'exclude_replies' => false
		) );
		if($twitterConnection->http_code != 200) {
			$twitterData = get_transient($transName);
		}
		set_transient($transName, $twitterData, 60 * $cacheTime);
	}
	$tweets = get_transient($transName);
}

$scoped_css = '';
$id = sm_shortcode_unique_id( 'sm-latest-tweet' );
$css_gen = new Inline_CSS_Generator( "sm-latest-tweet", $id );
if ( !empty( $color ) ) {
	$scoped_css .= $css_gen->css( array( '', '.tweet-item', '.tweet-time a' ), array( 'color' => $color ) );
	if ( 'sm-type1' == $type ) {
		$scoped_css .= $css_gen->css( array( '.tweet-pagination a' ), array( 'background-color' => $color ) );
	} else if ( 'sm-type2' == $type ) {
		$scoped_css .= $css_gen->css( array( '.tweet-nav', '.tweet-nav a' ), array( 'color' => $color ) );
	}
}

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<div class="tweet-icon"><i class="fa fa-twitter"></i></div>
	<?php if ( $tweets !== false && !empty( $tweets ) ) : ?>
	<div class="tweet-slider-wrap">
		<?php foreach ($tweets as $tweet): ?>
		<div class="tweet-item">
			<div class="tweet-text"><?php echo sm_wrap_tweet_links( $tweet->text ); ?></div>
			<div class="tweet-name">@<?php echo esc_html( $tweet->user->screen_name ); ?></div>
			<div class="tweet-time"><a href="http://twitter.com/<?php echo esc_attr( $tweet->user->screen_name ); ?>/statuses/<?php echo esc_attr( $tweet->id_str ); ?>"><?php echo sm_ago( strtotime ( $tweet->created_at ) ); ?></a></div>
		</div>
		<?php endforeach; ?>
	</div>
	<?php if ( 'sm-type1' == $type ) : ?>
		<div class="tweet-pagination <?php echo esc_attr( $bullet_shape ); ?>"></div>
	<?php else : ?>
		<div class="tweet-nav"><a href="javascript:;" class="prev"><i class="fa fa-caret-left"></i></a><a href="javascript:;" class="next"><i class="fa fa-caret-right"></i></a></div>
	<?php endif; ?>
<?php endif; ?>
</div>