<?php
extract( shortcode_atts( array(
	'images' => '',
	'type' => '',
	'nav_bullet_shape' => '',
	'columns' => '8',
	'autoplay' => '',
	'el_class' => ''
), $atts ) );
$image_ids = explode( ',', $images );
$type = sm_validate_with_array( $type, sm_get_image_slider_types_array() );
$nav_bullet_shape = sm_validate_with_array( $nav_bullet_shape, sm_get_nav_bullet_shapes_array() );

$css_class = array( 'sm-image-slider', 'sm_content_element', 'clearfix' );
$css_class[] = $type;
$css_class[] = $nav_bullet_shape;
$css_class = implode( ' ', $css_class );

$autoplay = sm_validate_with_array( $autoplay, sm_get_autoplay_intervals_array() );
$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
if ( !empty( $autoplay ) )
	$wrapper_attributes[] = 'data-autoplay="' . esc_attr( $autoplay ) . '"';
$wrapper_attributes[] = 'data-columns="' . esc_attr( $columns ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="flexslider sm-preview-slider">
		<ul class="slides">
	<?php
		foreach( $image_ids as $image_id ) :
	?>
			<li class="item"><?php echo wp_get_attachment_image( $image_id, 'full' ); ?></li>
	<?php
		endforeach;
	?>
		</ul>
	</div>
<?php if ( 'sm-type-thumb' == $type ) : ?>
	<div class="flexslider sm-thumbs-carousel">
		<ul class="slides">
	<?php
		foreach( $image_ids as $image_id ) :
			$image_url = wp_get_attachment_thumb_url( $image_id );
			$image_title = get_the_title( $image_id );
			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
			if ( empty( $image_alt ) ) $image_alt = $image_title;
	?>
			<li class="item"><a href="javascript:;"><img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" title="<?php echo esc_attr( $image_title ); ?>" /></a></li>
	<?php
		endforeach;
	?>
		</ul>
	</div>
<?php endif; ?>
</div>