<?php
extract ( shortcode_atts ( array (
	'font_size' => '',
	'font_weight' => '',
	'text_color' => '',
	'icon_color' => '',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '', 
), $atts ) );

$font_size = sm_validate_with_array( $font_size, sm_get_icon_list_item_font_sizes_array() );

$icon = sm_get_icon_from_atts( $atts );

$font_weight = sm_validate_with_array( $font_weight, sm_get_font_weight_array() );

$id = sm_shortcode_unique_id( 'sm_list_icon_item' );
$css_gen = new Inline_CSS_Generator( $id );

$scoped_css = '';

$css_class = array( 'sm-icon-list-item' );
if ( !empty( $font_weight ) ) 
$css_class[] = $font_weight;

if ( !empty( $icon_color ) ) $scoped_css .= $css_gen->css( '.pull-left', array( 'color' => $icon_color ) );
if ( !empty( $text_color ) ) $scoped_css .= $css_gen->css( '', array( 'color' => $text_color ) );
if ( !empty( $font_size ) ) $scoped_css .= $css_gen->css( '', array( 'font-size' => $font_size ) );
if ( $scoped_css != '' ) $css_class[] = $id;

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
	<i class="<?php echo esc_attr( $icon ); ?> pull-left"<?php if ( !empty( $inline_style ) ): ?> style="<?php echo esc_attr( $inline_style ); ?>" <?php endif; ?>></i><p><?php echo sm_do_kses( $content ); ?></p>
</div>
