<?php
extract( shortcode_atts( array(
	'date' => '',
	'style' => '',
	'text_color' => '#fff',
	'fg_color' => '#fff',
	'bg_color' => '#8e8d8d',
	'el_class' => '',
), $atts ) );

wp_enqueue_script( 'jquery.knob' );



$id = sm_shortcode_unique_id( "sm_countdown" );
$css_gen = new Inline_CSS_Generator( "sm-countdown", $id );
$scoped_css = '';
if ( !empty( $text_color ) ) {
	$scoped_css .= $css_gen->css( array( '.unit' ), array( 'color' => $text_color ) );
	$scoped_css .= $css_gen->css( array( '.element' ), array( 'color' => $text_color . ' !important' ) );
}

$style = sm_validate_with_array( $style, sm_get_countdown_styles_array() );

$css_class = array( 'sm-countdown', 'sm_content_element' );
$css_class[] = $style;
$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
$wrapper_attributes[] = 'data-date="' . esc_attr( $date ) . '"';
?>

<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
<?php if ( 'sm-style1' == $style ) : ?>
	<div class="row">
		<div class="column">
			<div class="sm_countdown_inner">
				<input class="element days" readonly="readonly" data-min="0" data-max="365" data-width="200" data-height="200" data-thickness="0.15" data-fgcolor="<?php echo esc_attr( $fg_color ); ?>" data-bgColor="<?php echo esc_attr( $bg_color ); ?>" data-angleoffset="180">
				<span class="unit days-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'days' ) ); ?></span>
			</div>
		</div>    
		<div class="column">
			<div class="sm_countdown_inner">
				<input class="element hour" readonly="readonly" data-min="0" data-max="24" data-width="200" data-height="200" data-thickness="0.15" data-fgcolor="<?php echo esc_attr( $fg_color ); ?>" data-bgColor="<?php echo esc_attr( $bg_color ); ?>" data-angleoffset="180">
				<span class="unit hours-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'hours' ) ); ?></span>
			</div>
		</div>    
		<div class="column"> 
			<div class="sm_countdown_inner">
				<input class="element minute" readonly="readonly" data-min="0" data-max="60" data-width="200" data-height="200" data-thickness="0.15" data-fgcolor="<?php echo esc_attr( $fg_color ); ?>" data-bgColor="<?php echo esc_attr( $bg_color ); ?>" data-angleoffset="180">
				<span class="unit mins-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'minutes' ) ); ?></span>
			</div>
		</div>
		<div class="column"> 
			<div class="sm_countdown_inner">
				<input class="element second" readonly="readonly" data-min="0" data-max="60" data-width="200" data-height="200" data-thickness="0.15" data-fgcolor="<?php echo esc_attr( $fg_color ); ?>" data-bgColor="<?php echo esc_attr( $bg_color ); ?>" data-angleoffset="180">
				<span class="unit secs-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'seconds' ) ); ?></span>
			</div>
		</div>
	</div>
<?php else : ?>
	<div class="row">
		<div class="column">
			<div class="sm_countdown_inner">
				<span class="element days"></span>
				<span class="unit days-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'days' ) ); ?></span>
			</div>
		</div>    
		<div class="column">
			<div class="sm_countdown_inner">
				<span class="element hour"></span>
				<span class="unit hours-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'hours' ) ); ?></span>
			</div>
		</div>    
		<div class="column"> 
			<div class="sm_countdown_inner">
				<span class="element minute"></span>
				<span class="unit mins-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'minutes' ) ); ?></span>
			</div>
		</div>
		<div class="column"> 
			<div class="sm_countdown_inner">
				<span class="element second"></span>
				<span class="unit secs-title"><?php echo esc_html( sm_get_countdown_units_string( $style, 'seconds' ) ); ?></span>
			</div>
		</div>
	</div>
<?php endif; ?>
</div>
