<?php

extract( shortcode_atts( array(
	'el_class' => '',
	'css_animation' => '',
	'animation_delay' => '',
	'css' => '',
	'bg_color_preset' => '',
), $atts ) );

$bg_color_preset = sm_validate_with_array( $bg_color_preset, sm_get_design_box_preset_bg_array() );

$css_class = array( 'sm_column_text', 'sm_content_element', $bg_color_preset );
$css_class = implode( ' ', $css_class );

$css_class .= sm_get_extra_class( $el_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_shortcode_custom_css_class( $css, ' ' );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="sm_wrapper">
		<?php echo sm_js_remove_wpautop( $content, true ); ?>
	</div>
</div>
