<?php
$output = $title = $el_id = '';

extract( shortcode_atts( array(
	'title' => esc_html__( 'Section', 'semona-extension' ),
	'el_id' => '',
), $atts ) );

$css_class = 'sm_accordion_section group';

$wrapper_attributes = array();
if ( !empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . $el_id . '"';
}
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<h3 class="sm_accordion_header ui-accordion-header"><a href="javascript:;"><?php echo esc_attr( $title ); ?></a></h3>
	<div class="sm_accordion_content ui-accordion-content vc_clearfix">
		<?php echo ( $content == '' || $content == ' ' ) ? esc_html__( "Empty section. Edit page to add content here.", 'semona-extension' ) : sm_js_remove_wpautop( $content, true ); ?>
	</div>
</div>