<?php

require_once( SM_SHORTCODE_PATH . '/hooks.php' );
require_once( SM_SHORTCODE_PATH . '/helpers.php' );

class Inline_CSS_Generator {
	private $class;
	private $id;
	
	public function __construct( $class, $id = '' ) {
		$this->class = $class != '' ? '.' . $class : '';
		$this->id = $id != '' ? '#' . $id : '';
	}
	public function css( $selectors, $params ) {
		if ( !is_array( $selectors ) ) {
			$selectors = array( $selectors );
		}
		$css = '';
		foreach ( $selectors as $selector ) {
			$css .= "{$this->class}{$this->id} {$selector},";
		}
		$css = substr( $css, 0, -1) . '{';
		if( is_array( $params ) ) {
			foreach( $params as $param_key => $param_value ) {
				if ( !empty( $param_value ) )
					$css .= "{$param_key}:{$param_value};";
			}
		}
		$css .= "}";
		return $css;
	}
	public function css_with_self_condition( $self_conditions, $selectors, $params ) {
		if ( empty( $self_conditions ) ) return;
		if ( !is_array( $self_conditions ) ) {
			$self_conditions = array( $self_conditions );
		}
		$css = '';
		foreach ( $self_conditions as $self_condition ) {
			if ( !is_array( $selectors ) ) {
				$selectors = array( $selectors );
			}
			foreach ( $selectors as $selector ) {
				$css .= "{$this->class}{$this->id}{$self_condition} {$selector},";
			}
			//$css .= "{$this->class}{$this->id}{$self_condition} {$selector},";
		}
		$css = substr( $css, 0, -1) . '{';
		if( is_array( $params ) ) {
			foreach( $params as $param_key => $param_value ) {
				if ( !empty( $param_value ) )
					$css .= "{$param_key}:{$param_value};";
			}
		}
		$css .= "}";
		return $css;
	} 
}

/* Initialization of Shortcodes for Visual Composer */
function sm_init_vc_shortcodes() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		
		vc_disable_frontend();
		
		if( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
			vc_set_shortcodes_templates_dir( SM_SHORTCODE_TEMPLATE_PATH );
		}
		
		vc_remove_element ( 'vc_accordion' );
		vc_remove_element ( 'vc_accordion_tab' );
		// vc_remove_element ( 'vc_basic_grid' );
		// vc_remove_element ( 'vc_btn' );
		vc_remove_element ( 'vc_column_text' );
		vc_remove_element ( 'vc_cta' );
		vc_remove_element ( 'vc_single_image' );
		vc_remove_element ( 'vc_message' );
		vc_remove_element ( 'vc_gallery' );
		vc_remove_element ( 'vc_images_carousel' );
		vc_remove_element ( 'vc_carousel' );
		vc_remove_element ( 'vc_progress_bar' );
		vc_remove_element ( 'vc_empty_space' );
		vc_remove_element ( 'vc_custom_heading' );
		vc_remove_element ( 'vc_pie' );
		vc_remove_element ( 'vc_tabs' );
		vc_remove_element ( 'vc_tab' );
		vc_remove_element ( 'vc_tour' );
		vc_remove_element ( 'vc_posts_slider' );
		vc_remove_element ( 'vc_masonry_grid' );
		vc_remove_element ( 'vc_wp_search' );
		vc_remove_element ( 'vc_wp_meta' );
		vc_remove_element ( 'vc_wp_recentcomments' );
		vc_remove_element ( 'vc_wp_calendar' );
		vc_remove_element ( 'vc_wp_pages' );
		vc_remove_element ( 'vc_wp_tagcloud' );
		vc_remove_element ( 'vc_wp_custommenu' );
		vc_remove_element ( 'vc_wp_text' );
		vc_remove_element ( 'vc_wp_posts' );
		vc_remove_element ( 'vc_wp_categories' );
		vc_remove_element ( 'vc_wp_archives' );
		vc_remove_element ( 'vc_wp_rss' );
		vc_remove_element ( 'vc_separator' );
	}
}
add_action( 'vc_before_init', 'sm_init_vc_shortcodes' );

/*
 * Load all required shortcodes
 */
function sm_load_shortcodes() {
	require_once( SM_SHORTCODE_CLASS_PATH . 'vc_row.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'vc_row_inner.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'vc_column.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'vc_column_inner.php' );

	require_once( SM_SHORTCODE_CLASS_PATH . 'accordion.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'accordion-tab.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'google-map.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'blog.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'button.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'callout.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'catalogue-item.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'contact-form.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'contact-info.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'countdown.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'counterbox.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'custom-heading.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'dropcap.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'empty-space.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'featurebox.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'blog-slider.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'highlight.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'icon.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'icon-list-item.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'image.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'image-carousel.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'image-slider.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'latest-tweet.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'logo.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'message.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'multi-scroll.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'multi-scroll-left-side.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'multi-scroll-right-side.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'multi-scroll-section.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'numbered-thumbnail.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'pageable-container.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'parallax-layers.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'portfolio.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'portfolio-carousel.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'pricing-column.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'pricing-table.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'pie.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'progress-steps.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'progressbar.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'quotes-slider.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'quote.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'rating.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'readmore.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'recent-posts.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'section-header.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'section-icon.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'separator.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'slide-image.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'social-links.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'stretch-container.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'tabs.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'tab.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'team-member.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'team-slider.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'team-slider-item.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'testimonial.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'testimonial-slider.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'testimonial-item.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'column_text.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'timeline.php' );
	require_once( SM_SHORTCODE_CLASS_PATH . 'vtabs.php' );

}
add_action( 'after_setup_theme', 'sm_load_shortcodes' );
//sm_load_shortcodes();
