<?php

function sm_register_shortcode_handler_sm_timeline() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_timeline extends WPBakeryShortCode {
			protected function outputTitle( $title ) {
				return '';
			}
			function content($atts, $content = null) {
				return sm_timeline_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_timeline', 'sm_timeline_func' );
	}
}

function sm_timeline_func( $atts, $content = '' ) {
	$view_params = array(
			'atts' => $atts,
			'content' => $content
	);
	return sm_render_view( 'timeline', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Timeline Posts', 'semona-extension' ),
	'base' => 'sm_timeline',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Timeline Posts', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-timeline.png',
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_timeline_post_styles_array(),
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'No. of Posts', 'semona-extension' ),
			'param_name' => 'count',
			'value' => '10',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Group by', 'semona-extension' ),
			'param_name' => 'group_by',
			'value' => sm_get_timeline_group_by_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'autocomplete',
			'heading' => esc_html__( 'Categories To Display', 'semona-extension' ),
			'param_name' => 'categories',
			'settings' => array(
				'multiple' => true,
				'min_length' => 1,
				'groups' => true,
				'unique_values' => true,
				'display_inline' => true,
				'delay' => 500,
				'auto_focus' => true,
			),
			//'param_holder_class' => 'vc_not-for-custom',
			'description' => esc_html__( 'Enter post categories.', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color Scheme', 'semona-extension' ),
			'param_name' => 'color_scheme',
			'value' => sm_get_timeline_color_schemes_array()
		),
		sm_extra_class(), 
	) 
) );

add_filter( 'vc_autocomplete_sm_timeline_categories_render', 'sm_timeline_categories_vc_autocomplete_render', 10, 1 );
function sm_timeline_categories_vc_autocomplete_render( $term ) {
	$terms = get_terms(
		array( 'category' ),
		array(
			'include' => array( $term['value'] ),
			'hide_empty' => false,
		)
	);
	$data = false;
	if ( is_array( $terms ) && 1 === count( $terms ) ) {
		$term = $terms[0];
		$data = array(
			'label' => $term->name,
			'value' => $term->term_id,
		);
	}

	return $data;
}

add_filter( 'vc_autocomplete_sm_timeline_categories_callback', 'sm_timeline_categories_vc_autocomplete_search', 10, 1 );
function sm_timeline_categories_vc_autocomplete_search( $search_string ) {
	$data = array();
	$terms = get_terms(
		array( 'category' ),
		array(
				'search' => $search_string,
				'hide_empty' => false,
		)
	);
	if ( is_array( $terms ) && ! empty( $terms ) ) {
		foreach ( $terms as $t ) {
			if ( is_object( $t ) ) {
				$data[] = array(
						'label' => $t->name,
						'value' => $t->term_id,
				);
			}
		}
	}

	return $data;
}