<?php
if ( defined( 'WPB_VC_VERSION' ) ) {
	class WPBakeryShortCode_sm_testimonial_item extends WPBakeryShortCode {
		function content($atts, $content = null) {
			return sm_testimonial_item_func( $atts, $content );
		}
	}
} else {
	add_shortcode( 'sm_testimonial_item', 'sm_testimonial_item_func' );
}

function sm_testimonial_item_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'testimonial-item', $view_params );
}

add_action( 'vc_before_init', 'vc_map_sm_testimonial_item' );
function vc_map_sm_testimonial_item() {
	vc_map( array(
		'name' => esc_html__( 'Testimonial Slider Item', 'semona-extension' ),
		'base' => 'sm_testimonial_item',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'description' => esc_html__( 'Testimonial Slider Item with avatar', 'semona-extension' ),
		'as_child' => array( 'only' => 'sm_testimonials' ),
		'content_element' => true,
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-testimonial_item.png',
		'params' => array(
			array (
				'type' => 'textfield',
				'heading' => esc_html__( 'Name', 'semona-extension' ),
				'param_name' => 'name',
				'value' => '',
				'admin_label' => true 
			),
			array (
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'semona-extension' ),
				'param_name' => 'company',
				'value' => '',
				'admin_label' => true 
			),
			array (
				'type' => 'attach_image',
				'heading' => esc_html__( 'Avatar', 'semona-extension' ),
				'param_name' => 'avatar',
				'admin_label' => true,
			),
			array (
				'type' => 'textarea',
				'heading' => esc_html__( 'Testimonial Content', 'semona-extension' ),
				'param_name' => 'content',
				'value' => '',
			),
			sm_extra_class()
		),
	) );
}

