<?php

function sm_register_shortcode_handler_sm_team_slider_item() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_team_slider_item extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_team_slider_item_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_team_slider_item', 'sm_team_slider_item_func' );
	}
}

function sm_team_slider_item_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'team-slider-item', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Team Slider Item', 'semona-extension' ),
	'base' => 'sm_team_slider_item',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-team_slider_item.png',
	'as_child' => array( 'only' => 'sm_team_slider' ),
	'params' => array_merge(
		array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Photo', 'semona-extension' ),
				'param_name' => 'photo',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Name', 'semona-extension' ),
				'param_name' => 'name',
				'value' => '',
				'admin_label' => true,
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'semona-extension' ),
				'param_name' => 'title',
				'value' => '',
				'admin_label' => true,
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__( 'Description', 'semona-extension' ),
				'param_name' => 'content',
				'value' => '',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Link', 'semona-extension' ),
				'param_name' => 'link',
				'value' => '',
			),
			sm_css_animation_class(),
			sm_css_animation_delay(),
			sm_extra_class(),
		),
		sm_get_social_links_options_array()
	)
) );