<?php

function sm_register_shortcode_handler_sm_slide_image() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-single-image.php' );
		class WPBakeryShortCode_sm_slide_image extends WPBakeryShortCode_VC_Single_image {
			function content($atts, $content = null) {
				return sm_slide_image_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_slide_image', 'sm_slide_image_func' );
	}
}

function sm_slide_image_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'slide-image', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Slide Image', 'semona-extension' ),
	'base' => 'sm_slide_image',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'allowed_container_element' => 'vc_row',
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-slide_image.png',
	'description' => esc_html__( 'Slide image in a frame', 'semona-extension' ),
	'params' => array (
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Image', 'semona-extension' ),
			'param_name' => 'image'
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Slide Type', 'semona-extension' ),
			'param_name' => 'type',
			'value' => sm_get_slide_image_types_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image Frame', 'semona-extension' ),
			'param_name' => 'frame',
			'value' => sm_get_slide_image_frames_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'URL', 'semona-extension' ),
			'param_name' => 'image_link',
			'description' => esc_html__( 'Leave blank for no link.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-8 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),
			'param_name' => 'open_new',
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class()
	)
) );