<?php

function sm_register_shortcode_handler_sm_separator() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_separator extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_separator_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_separator', 'sm_separator_func' );
	}
}

function sm_separator_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'separator', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Separator', 'semona-extension' ),
	'base' => 'sm_separator',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-separator.png',
	'params' => array (
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_separator_styles_array(),
			'description' => esc_html__( 'Separator display style.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Alignment', 'semona-extension' ),
			'param_name' => 'align',
			'value' => sm_get_default_aligns_array(),
			'description' => esc_html__( 'Select separator alignment.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border width', 'semona-extension' ),
			'param_name' => 'border_width',
			'value' => sm_get_separator_border_widths_array(),
			'description' => esc_html__( 'Select border width (pixels).', 'semona-extension' ),
			'dependency' => array(
				'element' => 'style',
				'value' => array( '' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Element width', 'semona-extension' ),
			'param_name' => 'el_width',
			'description' => esc_html__( 'Note: CSS measurement units allowed.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'style',
				'value' => array( '' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Margin Top (px)', 'semona-extension' ),
			'param_name' => 'margin_top',
			'description' => esc_html__( 'Specify Margin Top.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Margin Bottom (px)', 'semona-extension' ),
			'param_name' => 'margin_bottom',
			'description' => esc_html__( 'Specify Margin Bottom.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'semona-extension' ),
			'param_name' => 'color',
			'value' => sm_get_preset_border_colors_array(),
			'std' => '',
			'description' => esc_html__( 'Select color of separator.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Color', 'semona-extension' ),
			'param_name' => 'custom_color',
			'description' => esc_html__( 'Select custom color for your element.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'color',
				'value' => array( 'custom' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class()
	) 
) );
