<?php

function sm_register_shortcode_handler_sm_section_icon() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_section_icon extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_section_icon_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_section_icon', 'sm_section_icon_func' );
	}
}

function sm_section_icon_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'section-icon', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Section Icon', 'semona-extension' ),
	'base' => 'sm_section_icon',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-section_icon.png',
	'show_settings_on_create' => true,
	'params' => array_merge(
		array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon Wrapper Type', 'semona-extension' ),
				'description' => esc_html__( 'Icon Wrapper Type.', 'semona-extension' ),
				'param_name' => 'wrapper_type',
				'value' => sm_get_section_icon_wrapper_types_array(),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Custom Polygon Points', 'semona-extension' ),
				'description' => esc_html__( 'Type custom polygon points in x,y pair separated by space. Values should be between 1-99.(ex. 7,22 93,22 50,97)', 'semona-extension' ),
				'param_name' => 'polygon_points',
				'dependency' => array(
					'element' => 'wrapper_type',
					'value' => 'custom'
				)
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Show Pendulum', 'semona-extension' ),
				'description' => esc_html__( 'Put checkmark to show pendulum-like vertical line and circle.', 'semona-extension' ),
				'param_name' => 'show_vline',
				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
				'std' => 'yes',
			),
		),
		sm_get_icon_options_array(),
		array (
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Scroll To Row Container', 'semona-extension' ),
				'description' => esc_html__( 'Put checkmark to make the icon-click scroll to top of the row.', 'semona-extension' ),
				'param_name' => 'scroll_to_row',
				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
				'std' => 'yes',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Background Style', 'semona-extension' ),
				'description' => esc_html__( 'Select background style.', 'semona-extension' ),
				'param_name' => 'bg_style',
				'value' => sm_get_section_icon_color_styles_array(),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Background Color', 'semona-extension' ),
				'param_name' => 'bg_color',
				'description' => esc_html__( 'Select Icon color.', 'semona-extension' ),
				'param_holder_class' => 'sm-preset-color-dropdown',
				'value' => sm_get_preset_colors_array( false, false, false ),
				'dependency' => array(
					'element' => 'bg_style',
					'value' => array( 'sm-style-solid' )
				),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Color Style', 'semona-extension' ),
				'description' => esc_html__( 'Select border color to apply.', 'semona-extension' ),
				'param_name' => 'border_color',
				'value' => sm_get_section_icon_border_colors_array(),
				'group' => esc_html__( 'Colors', 'semona-extension' ),
			),
		)
	)
) );
