<?php

function sm_register_shortcode_handler_sm_section_header() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_section_header extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_section_header_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_section_header', 'sm_section_header_func' );
	}
}

function sm_section_header_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'section-header', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Section Header', 'semona-extension' ),
	'base' => 'sm_section_header',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-section_header.png',
	'params' => array (
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Preheader Text', 'semona-extension' ),
			'param_name' => 'subtitle',
			'description' => esc_html__( 'Text above title. (Optional)', 'semona-extension' ),
			'admin_label' => true 
		),
		array (
			'type' => 'textarea',
			'heading' => esc_html__( 'Heading Title', 'semona-extension' ),
			'param_name' => 'title',
			'value' => esc_html__( 'Heading Title', 'semona-extension' ),
			'admin_label' => true 
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Alignment', 'semona-extension' ),
			'param_name' => 'align',
			'value' => sm_get_default_aligns_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Letter Spacing', 'semona-extension' ),
			'param_name' => 'letter_spacing',
			'value' => sm_get_letter_spacings_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => 'Heading Color',
			'param_name' => 'text_color',
			'description' => esc_html__( 'Leave blank to use default theme heading color.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Preheader Color', 'semona-extension' ),
			'param_name' => 'subtitle_color',
			'value' => sm_get_preheader_colors_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show Underline', 'semona-extension' ),
			'param_name' => 'show_underline',
			'description' => esc_html__( 'If checked, displays a underline below title.', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'std' => 'yes',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_section_header_styles_array(),
			'dependency' => array(
				'element' => 'show_underline',
				'value' => array( 'yes' )
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => 'Underline Color',
			'param_name' => 'underline_color',
			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'show_underline',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Underline Width (px)', 'semona-extension' ),
			'param_name' => 'underline_width',
			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'style',
				'value_not_equal_to' => array( 'sm-style-diamond' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Put a period', 'semona-extension' ),
			'param_name' => 'put_period',
			'description' => esc_html__( 'If checked, puts a colored period(.) at the end of title.', 'semona-extension' ),
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class()
	) 
) );
