<?php

function sm_register_shortcode_handler_sm_progressbar() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_progressbar extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_progressbar_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_progressbar', 'sm_progressbar_func' );
	}
}

function sm_progressbar_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'progressbar', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Progress Bar', 'semona-extension' ),
	'base' => 'sm_progressbar',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-progressbar.png',
	'params' => array (
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'semona-extension' ),
			'param_name' => 'title',
			'value' => esc_html__( 'Title', 'semona-extension' ),
			'admin_label' => true,
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Progress Value', 'semona-extension' ),
			'param_name' => 'value',
			'value' => '50',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Unit', 'semona-extension' ),
			'param_name' => 'unit',
			'value' => '%',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Shape', 'semona-extension' ),
			'param_name' => 'shape',
			'value' => sm_get_progressbar_shapes_array(),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_progressbar_styles_array(),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Foreground Color Style', 'semona-extension' ),
			'description' => esc_html__( 'Select progress bar foreground color style.', 'semona-extension' ),
			'param_name' => 'fg_style',
			'value' => sm_get_background_styles_array(),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Foreground Color', 'semona-extension' ),
			'param_name' => 'fg_color',
			'description' => esc_html__( 'Select foreground color.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_colors_array( false, false ),
			'dependency' => array(
				'element' => 'fg_style',
				'value' => array( 'sm-style-solid' )
			),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Foreground Color', 'semona-extension' ),
			'param_name' => 'custom_fg_color',
			'description' => esc_html__( 'Select custom background color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'fg_color',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Gradient Color 1', 'semona-extension' ),
			'param_name' => 'grad_color1',
			'description' => esc_html__( 'Select foreground gradient start color for the element.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_colors_array( false, false ),
			'dependency' => array(
				'element' => 'fg_style',
				'value' => array( 'sm-style-gradient' )
			),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Gradient Color 1', 'semona-extension' ),
			'param_name' => 'custom_grad_color1',
			'description' => esc_html__( 'Select custom foreground gradient start color for the element.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'grad_color1',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),

		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Gradient Color 2', 'semona-extension' ),
			'param_name' => 'grad_color2',
			'description' => esc_html__( 'Select foreground gradient end color for the element.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_colors_array( false, false ),
			'dependency' => array(
				'element' => 'fg_style',
				'value' => array( 'sm-style-gradient' )
			),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Gradient Color 2', 'semona-extension' ),
			'param_name' => 'custom_grad_color2',
			'description' => esc_html__( 'Select custom foreground gradient end color for the element', 'semona-extension' ),
			'dependency' => array(
				'element' => 'grad_color2',
				'value' => array( 'custom' )
			),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Background Color', 'semona-extension' ),
			'param_name' => 'bg_color',
			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Text Color', 'semona-extension' ),
			'param_name' => 'text_color',
			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
			'group' => esc_html__( 'Styles', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class()
	)
) );
