<?php

function sm_register_shortcode_handler_sm_pricing_column() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_pricing_column extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_pricing_column_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_pricing_column', 'sm_pricing_column_func' );
	}
}

function sm_pricing_column_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'pricing-column', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Pricing Column', 'semona-extension' ),
	'base' => 'sm_pricing_column',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-pricing_column.png',
	'as_child' => array( 'only' => 'sm_pricing_table' ),
	'content_element' => true,
	'params' => array (
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'semona-extension' ),
			'param_name' => 'title',
			'value' => '',
			'admin_label' => true 
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Currency', 'semona-extension' ),
			'param_name' => 'currency',
			'value' => '$',
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Price Text', 'semona-extension' ),
			'param_name' => 'price',
			'value' => '',
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Period', 'semona-extension' ),
			'param_name' => 'period',
			'value' => '/month',
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		array (
			'type' => 'textarea',
			'heading' => esc_html__( 'Features', 'semona-extension' ),
			'param_name' => 'content',
			'value' => '',
			'description' => esc_html__( 'Put each feature in different line. Simple HTML tags such as &lt;strong&gt;,&lt;em&gt; are allowed.', 'semona-extension' ),
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Button Caption', 'semona-extension' ),
			'param_name' => 'button_caption',
			'value' => '',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Button Link', 'semona-extension' ),
			'param_name' => 'button_link',
			'edit_field_class' => 'vc_col-sm-8 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),
			'param_name' => 'open_new',
			'edit_field_class' => 'vc_col-sm-4 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Column Color', 'semona-extension' ),
			'param_name' => 'color',
			'description' => esc_html__( 'Select color of the column.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_colors_array( true, false ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Column Color', 'semona-extension' ),
			'param_name' => 'custom_color',
			'description' => esc_html__( 'Select custom color of the column.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'color',
				'value' => array( 'custom' )
			),
		),
		array (
			'type' => 'dropdown',
			'heading' => esc_html__( 'Featured Column', 'semona-extension' ),
			'param_name' => 'featured',
			'value' => array(
				esc_html__( 'No', 'semona-extension' ) => '',
				esc_html__( 'Yes', 'semona-extension' ) => 'yes',
			),
			'admin_label' => true,
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Featured String', 'semona-extension' ),
			'param_name' => 'featured_text',
			'value' => 'hot',
			'dependency' => array(
				'element' => 'featured',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array (
			'type' => 'dropdown',
			'heading' => esc_html__( 'Raised Style', 'semona-extension' ),
			'param_name' => 'raised',
			'value' => array(
				esc_html__( 'No', 'semona-extension' ) => '',
				esc_html__( 'Yes', 'semona-extension' ) => 'yes',
			),
			'description' => esc_html__( 'Choose \'Yes\' to make it standout with shadow.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'featured',
				'value' => array( 'yes' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Featured Badge Color', 'semona-extension' ),
			'param_name' => 'badge_color',
			'description' => esc_html__( 'Select badge color of the featured column.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_colors_array( true, false ),
			'dependency' => array(
				'element' => 'featured',
				'value' => array( 'yes' )
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Featured Badge Color', 'semona-extension' ),
			'param_name' => 'custom_badge_color',
			'description' => esc_html__( 'Select custom badge color of the featured column.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'badge_color',
				'value' => array( 'custom' )
			),
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class() 
	) 
) );