<?php

function sm_pageable_container_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'pageable-container', $view_params );
}

function sm_register_shortcode_handler_sm_pageable_container() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-tabs.php' );
		class WPBakeryShortCode_sm_pageable_container extends WPBakeryShortCode_VC_Tabs {
			public function getTabTemplate() {
				return '<div class="wpb_template">' . do_shortcode( '[sm_tab title="Tab" tab_id=""][/sm_tab]' ) . '</div>';
			}
			function content($atts, $content = null) {
				return sm_pageable_container_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_pageable_container', 'sm_pageable_container_func' );
	}
}

$tab_id_1 = 'def' . time() . '-1-' . rand( 0, 100 );
$tab_id_2 = 'def' . time() . '-2-' . rand( 0, 100 );

sm_register_shortcode( array (
	'name' => esc_html__( 'Pageable Container', 'semona-extension' ),
	'base' => 'sm_pageable_container',
	'show_settings_on_create' => false,
	'is_container' => true,
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Pageable content container', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-pageable_container.png',
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'semona-extension' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'semona-extension' )
		),
		/*
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Auto rotate', 'semona-extension' ),
			'param_name' => 'interval',
			'value' => array( esc_html__( 'Disable', 'semona-extension' ) => 0, 3, 5, 10, 15 ),
			'std' => 0,
			'description' => esc_html__( 'Auto rotate tabs each X seconds.', 'semona-extension' )
		),*/
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Circle Text Color', 'semona-extension' ),
			'param_name' => 'circle_text_color',
			'description' => esc_html__( 'Specify circle text color for icon or number.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Circle Background Color', 'semona-extension' ),
			'param_name' => 'circle_bg_color',
			'description' => esc_html__( 'Specify circle background color for icon or number.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Section Title Color', 'semona-extension' ),
			'param_name' => 'section_title_color',
			'description' => esc_html__( 'Specify section title color below the circle.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Section Background Color', 'semona-extension' ),
			'param_name' => 'section_bg_color',
			'description' => esc_html__( 'Specify section title color below the circle.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		
		sm_extra_class()
	),
	'custom_markup' => '
<div class="wpb_tabs_holder wpb_holder vc_container_for_children">
<ul class="tabs_controls">
</ul>
%content%
</div>'
,
	'default_content' => '
[sm_tab title="' . esc_html__( 'Page 1', 'semona-extension' ) . '" tab_id="' . $tab_id_1 . '"][/sm_tab]
[sm_tab title="' . esc_html__( 'Page 2', 'semona-extension' ) . '" tab_id="' . $tab_id_2 . '"][/sm_tab]
',
	'js_view' => 'SMTabsView'
) );

