<?php
if ( defined( 'WPB_VC_VERSION' ) ) {
	class WPBakeryShortCode_sm_multi_scroll_left_side extends WPBakeryShortCodesContainer {
		function content($atts, $content = null) {
			return sm_multi_scroll_left_side_func( $atts, $content );
		}
	}
} else {
	add_shortcode( 'sm_multi_scroll_left_side', 'sm_multi_scroll_left_side_func' );
}

function sm_multi_scroll_left_side_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'multi-scroll-left-side', $view_params );
}

add_action( 'vc_before_init', 'vc_map_sm_multi_scroll_left_side' );
function vc_map_sm_multi_scroll_left_side() {
	vc_map( array(
		'name' => esc_html__( 'Left-side Container', 'semona-extension' ),
		'base' => 'sm_multi_scroll_left_side',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'as_child' => array( 'only' => 'sm_multi_scroll' ),
		'as_parent' => array( 'only' => 'sm_multi_scroll_section' ),
		'content_element' => true,
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-multi_scroll_left_side.png',
		'params' => array(
			sm_extra_class()
		),
		'js_view' => 'VcColumnView',
	) );
}

