<?php

function sm_register_shortcode_handler_sm_latest_tweet() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_latest_tweet extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_latest_tweet_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_latest_tweet', 'sm_latest_tweet_func' );
	}
}

function sm_latest_tweet_func( $atts, $content = "" ) {
	$atts = array_merge( $atts, sm_get_theme_tweet_settings() );
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'latest-tweet', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Latest Tweet', 'semona-extension' ),
	'base' => 'sm_latest_tweet',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Latest Tweet', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-latest_tweet.png',
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Type', 'semona-extension' ),
			'param_name' => 'type',
			'value' => sm_get_tweet_types_array(),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon Style', 'semona-extension' ),
			'param_name' => 'icon_style',
			'value' => sm_get_tweet_icon_styles_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'No. of Tweets', 'semona-extension' ),
			'param_name' => 'count',
			'value' => sm_get_tweet_numbers_array(),
			'admin_label' => true,
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Content Color', 'semona-extension' ),
			'param_name' => 'color',
			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Navigation Bullet Shape', 'semona-extension' ),
			'value' => sm_get_nav_bullet_shapes_array(),
			'param_name' => 'bullet_shape',
			'description' => esc_html__( 'Select navigation bullet shape.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		/*
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Twitter ID', 'semona-extension' ),
			'param_name' => 'twitter_id',
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Consumer Key', 'semona-extension' ),
			'param_name' => 'consumer_key',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Consumer Secret', 'semona-extension' ),
			'param_name' => 'consumer_secret',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Access Token', 'semona-extension' ),
			'param_name' => 'access_token',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Access Token Secret', 'semona-extension' ),
			'param_name' => 'access_token_secret',
		),*/
		sm_extra_class()
	)
) );
