<?php

function sm_register_shortcode_handler_sm_image_slider() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_image_slider extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_image_slider_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_image_slider', 'sm_image_slider_func' );
	}
}

function sm_image_slider_func( $atts, $content = null ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'image-slider', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Image Slider', 'semona-extension' ),
	'base' => 'sm_image_slider',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-image_slider.png',
	'params' => array (
		array (
			'type' => 'attach_images',
			'heading' => esc_html__( 'Images', 'semona-extension' ),
			'param_name' => 'images',
		),
		array (
			'type' => 'dropdown',
			'heading' => esc_html__( 'Slider Type', 'semona-extension' ),
			'param_name' => 'type',
			'value' => sm_get_image_slider_types_array(),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Navigation Bullet Shape', 'semona-extension' ),
			'value' => sm_get_nav_bullet_shapes_array(),
			'param_name' => 'nav_bullet_shape',
			'description' => esc_html__( 'Select navigation bullet shape.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'type',
				'value' => 'sm-type-basic'
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array (
			'type' => 'textfield',
			'heading' => esc_html__( 'Thumbnail Columns', 'semona-extension' ),
			'param_name' => 'columns',
			'value' => '8',
			'dependency' => array(
				'element' => 'type',
				'value' => array( 'sm-type-thumb' )
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array (
			'type' => 'dropdown',
			'heading' => esc_html__( 'Autoplay', 'semona-extension' ),
			'param_name' => 'autoplay',
			'value' => sm_get_autoplay_intervals_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		sm_extra_class(),
	)
) );