<?php

function sm_icon_list_item_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'icon-list-item', $view_params );
}

function sm_register_shortcode_handler_sm_icon_list_item() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_icon_list_item extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_icon_list_item_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_icon_list_item', 'sm_icon_list_item_func' );
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Icon List Item', 'semona-extension' ),
	'base' => 'sm_icon_list_item',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-icon_list_item.png',
	'params' => array_merge(
		array (
			array (
				'type' => 'textarea',
				'heading' => esc_html__( 'Text', 'semona-extension' ),
				'param_name' => 'content',
				'value' => esc_html__( 'List Item Text', 'semona-extension' ),
				'admin_label' => true 
			),
		),
		sm_get_icon_options_array(),
		array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Font Size', 'semona-extension' ),
				'param_name' => 'font_size',
				'value' => sm_get_icon_list_item_font_sizes_array(),
				'description' => esc_html__( 'Select font size.', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Font Weight', 'semona-extension' ),
				'param_name' => 'font_weight',
				'value' => sm_get_font_weight_array(),
				'description' => esc_html__( 'Select font weight.', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Text Color', 'semona-extension' ),
				'param_name' => 'text_color',
				'value' => '',
				'description' => esc_html__( 'Select text color. Leave blank to use default text color.', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Icon Color', 'semona-extension' ),
				'param_name' => 'icon_color',
				'value' => '',
				'description' => esc_html__( 'Select icon color. Leave blank to use primary color.', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			sm_css_animation_class(),
			sm_css_animation_delay(),
			sm_extra_class()
		)
	) 
) );
