<?php

function sm_custom_heading_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'custom-heading', $view_params );
}

function sm_register_shortcode_handler_sm_custom_heading() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_custom_heading extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_custom_heading_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_custom_heading', 'sm_custom_heading_func' );
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Custom Heading', 'semona-extension' ),
	'base' => 'sm_custom_heading',
	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Custom Heading', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-custom_heading.png',
	'params' => array_merge(
		array (
			array (
				'type' => 'textarea',
				'heading' => esc_html__( 'Heading', 'semona-extension' ),
				'param_name' => 'content',
				'value' => esc_html__( 'Heading here', 'semona-extension' ),
				'holder' => 'div'
			),
			array (
				'type' => 'dropdown',
				'heading' => esc_html__( 'Heading Tag', 'semona-extension' ),
				'param_name' => 'heading_tag',
				'value' => sm_get_heading_tags_array(),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Alignment', 'semona-extension' ),
				'param_name' => 'align',
				'value' => sm_get_default_aligns_array(),
				'edit_field_class' => 'vc_col-sm-3 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Font Size', 'semona-extension' ),
				'param_name' => 'font_size',
				'value' => sm_get_custom_heading_font_sizes_array(),
				'edit_field_class' => 'vc_col-sm-3 vc_column',
			),
			array (
				'type' => 'dropdown',
				'heading' => esc_html__( 'Font Weight', 'semona-extension' ),
				'param_name' => 'font_style',
				'value' => sm_get_font_weight_array(),
				'param_holder_class' => 'sm-font-style-dropdown',
				'edit_field_class' => 'vc_col-sm-3 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Letter Spacing', 'semona-extension' ),
				'param_name' => 'letter_spacing',
				'value' => sm_get_letter_spacings_array(),
				'edit_field_class' => 'vc_col-sm-3 vc_column',
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Uppercase', 'semona-extension' ),
				'param_name' => 'uppercase',
				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
				'edit_field_class' => 'vc_col-sm-3 vc_column',
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Italic', 'semona-extension' ),
				'param_name' => 'italic',
				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
				'edit_field_class' => 'vc_col-sm-3 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Text Color',
				'param_name' => 'text_color',
				'value' => '',
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Show Underline', 'semona-extension' ),
				'param_name' => 'underline',
				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
				'std' => 'yes',
				'description' => esc_html__( 'Put checkmark to show underline.', 'semona-extension' ),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Underline Color',
				'param_name' => 'underline_color',
				'value' => '',
				'dependency' => array(
					'element' => 'underline',
					'value' => 'yes',
				),
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array (
				'type' => 'textfield',
				'heading' => esc_html__( 'Width (px, %, em)', 'semona-extension' ),
				'param_name' => 'underline_width',
				'value' => '',
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
				'dependency' => array(
					'element' => 'underline',
					'value' => 'yes',
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array (
				'type' => 'dropdown',
				'heading' => esc_html__( 'Underline Thickness', 'semona-extension' ),
				'param_name' => 'underline_thickness',
				'value' => sm_get_custom_heading_border_widths_array(),
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				'description' => esc_html__( 'Default: 2px.', 'semona-extension' ),
				'dependency' => array(
					'element' => 'underline',
					'value' => 'yes',
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Show Midline', 'semona-extension' ),
				'param_name' => 'midline',
				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
				'description' => esc_html__( 'Put checkmark to show midline.', 'semona-extension' ),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array(
				'type' => 'colorpicker',
				'heading' => 'Midline Color',
				'param_name' => 'midline_color',
				'value' => '',
				'dependency' => array(
					'element' => 'midline',
					'value' => 'yes',
				),
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array (
				'type' => 'textfield',
				'heading' => esc_html__( 'Midline Width (px, %, em)', 'semona-extension' ),
				'param_name' => 'midline_width',
				'value' => '',
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
				'dependency' => array(
					'element' => 'midline',
					'value' => 'yes',
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			array (
				'type' => 'dropdown',
				'heading' => esc_html__( 'Midline Thickness', 'semona-extension' ),
				'param_name' => 'midline_thickness',
				'value' => sm_get_custom_heading_border_widths_array(),
				'edit_field_class' => 'vc_col-sm-4 vc_column',
				'description' => esc_html__( 'Default: 4px.', 'semona-extension' ),
				'dependency' => array(
					'element' => 'midline',
					'value' => 'yes',
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
		),
		sm_get_icon_options_array( esc_html__( 'Styling', 'semona-extension' ), true ),
		array(	
			array(
				'type' => 'colorpicker',
				'heading' => 'Icon Color',
				'param_name' => 'icon_color',
				'value' => '',
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array( 'fontawesome' ),
				),
				'group' => esc_html__( 'Styling', 'semona-extension' ),
			),
			sm_css_animation_class(),
			sm_css_animation_delay(),
			sm_extra_class()
		)
	) 
) );