<?php

function sm_register_shortcode_handler_sm_countdown() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_countdown extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_countdown_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_countdown', 'sm_countdown_func' );
	}
}

function sm_countdown_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'countdown', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Countdown Timer', 'semona-extension' ),
	'base' => 'sm_countdown',
	'class' => '',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Animated countdown chart', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-countdown.png',
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Final Date', 'semona-extension' ),
			'param_name' => 'date',
			'description' => esc_html__( 'Enter a valid date in \'YYYY/MM/DD hh:mm:ss\' format.', 'semona-extension' ),
			'admin_label' => true
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_countdown_styles_array(),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Text Color', 'semona-extension' ),
			'param_name' => 'text_color',
			'description' => esc_html__( 'Select counter text Color.', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Stroke Color', 'semona-extension' ),
			'param_name' => 'fg_color',
			'description' => esc_html__( 'Select counter stroke foreground color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'style',
				'value' => 'sm-style1'
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Stroke Background Color', 'semona-extension' ),
			'param_name' => 'bg_color',
			'description' => esc_html__( 'Select stroke background color.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'style',
				'value' => 'sm-style1'
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		sm_extra_class()
	)
) );
