<?php

function sm_register_shortcode_handler_sm_column_text() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_column_text extends WPBakeryShortCode {
			protected function outputTitle( $title ) {
				return '';
			}
			function content($atts, $content = null) {
				return sm_column_text_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_column_text', 'sm_column_text_func' );
	}
}

function sm_column_text_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'column_text', $view_params );
}

sm_register_shortcode( array(
	'name' => esc_html__( 'Text Block', 'semona-extension' ),
	'base' => 'sm_column_text',
	'wrapper_class' => 'clearfix',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'A block of text with WYSIWYG editor', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-column_text.png',
	'params' => array(
		array(
			'type' => 'textarea_html',
			'holder' => 'div',
			'heading' => esc_html__( 'Text', 'semona-extension' ),
			'param_name' => 'content',
			'value' => sm_do_kses( esc_html__( 'I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'semona-extension' ) )
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class(),
		sm_css_box_option(),
		sm_bg_color_preset_option()
	)
) );
?>