<?php

function sm_register_shortcode_handler_sm_catalogue_item() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_catalogue_item extends WPBakeryShortCode {
			protected function outputTitle( $title ) {
				return '';
			}
			function content($atts, $content = null) {
				return sm_catalogue_item_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_blog', 'sm_blog_func' );
	}
}

function sm_catalogue_item_func( $atts, $content = '' ) {
	$view_params = array(
			'atts' => $atts,
			'content' => $content
	);
	return sm_render_view( 'catalogue-item', $view_params );
}

sm_register_shortcode( array (
		'name' => esc_html__( 'Catalogue Item', 'semona-extension' ),
		'base' => 'sm_catalogue_item',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-catalogue_item.png',
		'params' => array (
				array (
						'type' => 'dropdown',
						'heading' => esc_html__( 'Style', 'semona-extension' ),
						'param_name' => 'style',
						'value' => array (
								esc_html__( 'With Image', 'semona-extension' ) => 'with-image1',
								esc_html__( 'Simple', 'semona-extension' ) => 'simple',
						),
						'admin_label' => true,
				),
				array (
						'type' => 'textarea_html',
						'heading' => esc_html__( 'Description Content', 'semona-extension' ),
						'param_name' => 'content',
						'value' => '',
						'description' => esc_html__( 'Enter content such as title and description. You can change style of the content in this text editor.', 'semona-extension' ),
				),
				array (
						'type' => 'textfield',
						'heading' => esc_html__( 'Price Tag', 'semona-extension' ),
						'param_name' => 'price',
						'value' => '',
						'description' => esc_html__( 'Enter your price tag, e.g. $100.', 'semona-extension' ),
				),
				array(
						'type' => 'attach_image',
						'heading' => esc_html__( 'Image', 'semona-extension' ),
						'param_name' => 'image',
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'with-image1' ),
						),
				),
				array (
						'type' => 'dropdown',
						'heading' => esc_html__( 'Show white border around image', 'semona-extension' ),
						'param_name' => 'show_padding',
						'value' => array (
								esc_html__( 'No', 'semona-extension' ) => 'no',
								esc_html__( 'Yes', 'semona-extension' ) => 'yes',
						),
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'with-image1' ),
						),
				),
				array (
						'type' => 'textfield',
						'heading' => esc_html__( 'Font Size (px)', 'semona-extension' ),
						'param_name' => 'fontsize',
						'value' => '',
						'description' => esc_html__( 'Enter the font size in numbers in simple style. Leave blank to use default theme font size.', 'semona-extension' ),
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'simple' ),
						),
				),
				/* With image style colors */
				array (
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Image Border Color', 'semona-extension' ),
						'param_name' => 'image_border_color',
						'value' => '',
						'description' => esc_html__( 'Choose image border color.', 'semona-extension' ),
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'with-image1' ),
						),
						'group' => esc_html__( 'Colors', 'semona-extension' ),
				),
				array (
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Price Tag Color', 'semona-extension' ),
						'param_name' => 'price_color',
						'value' => '',
						'description' => esc_html__( 'Choose price tag text color.', 'semona-extension' ),
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'with-image1' ),
						),
						'group' => esc_html__( 'Colors', 'semona-extension' ),
				),
				array (
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Price Tag Bg Color', 'semona-extension' ),
						'param_name' => 'price_bg_color',
						'value' => '',
						'description' => esc_html__( 'Choose price tag background color.', 'semona-extension' ),
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'with-image1' ),
						),
						'group' => esc_html__( 'Colors', 'semona-extension' ),
				),
				/* Simple style colors */
				array (
						'type' => 'colorpicker',
						'heading' => esc_html__( 'Text Color', 'semona-extension' ),
						'param_name' => 'textcolor',
						'value' => '',
						'description' => esc_html__( 'Choose text color in simple style. Leave blank to use default theme text color.', 'semona-extension' ),
						'dependency' => array(
								'element' => 'style',
								'value' => array( 'simple' ),
						),
						'group' => esc_html__( 'Colors', 'semona-extension' ),
				),
				sm_extra_class(), 
		) 
) );
