<?php

function sm_register_shortcode_handler_sm_blog() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_blog extends WPBakeryShortCode {
			protected function outputTitle( $title ) {
				return '';
			}
			function content($atts, $content = null) {
				return sm_blog_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_blog', 'sm_blog_func' );
	}
}

function sm_blog_func( $atts, $content = '' ) {
	$view_params = array(
			'atts' => $atts,
			'content' => $content
	);
	return sm_render_view( 'blog', $view_params );
}

sm_register_shortcode( array (
		'name' => esc_html__( 'Blog Posts', 'semona-extension' ),
		'base' => 'sm_blog',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-blog.png',
		'params' => array (
				array (
						'type' => 'dropdown',
						'heading' => esc_html__( 'Blog Style', 'semona-extension' ),
						'param_name' => 'style',
						'value' => array (
								esc_html__( 'Classic', 'semona-extension' ) => 'classic',
								esc_html__( 'Grid', 'semona-extension' ) => 'grid',
								esc_html__( 'Masonry', 'semona-extension' ) => 'masonry',
								esc_html__( 'Simple Grid', 'semona-extension' ) => 'simple',
								esc_html__( 'Simple List', 'semona-extension' ) => 'simple-list',
								esc_html__( 'Modern', 'semona-extension' ) => 'modern',
						),
						'admin_label' => true,
				),
				array (
						'type' => 'dropdown',
						'heading' => esc_html__( 'Grid/Masonry/Simple/Modern Columns', 'semona-extension' ),
						'param_name' => 'column_count',
						'value' => array (
								'1' => '1',
								'2' => '2',
								'3' => '3',
								'4' => '4' 
						),
				),
				array (
						'type' => 'textfield',
						'heading' => esc_html__( 'Posts Per Page', 'semona-extension' ),
						'param_name' => 'per_page',
						'value' => '',
						'description' => esc_html__( 'Leave empty for using default theme option value.', 'semona-extension' ),
				),
				array (
						'type' => 'dropdown',
						'heading' => esc_html__( 'Pagination Type', 'semona-extension' ),
						'param_name' => 'pagination_type',
						'value' => array (
								esc_html__( 'None', 'semona-extension' ) => 'none',
								esc_html__( 'Pagination', 'semona-extension' ) => 'pagination',
								esc_html__( 'Load More Button', 'semona-extension' ) => 'loadmore',
								esc_html__( 'Infinite Scroll', 'semona-extension' ) => 'infinitescroll',
						),
						'dependency' => array(
								'element' => 'style',
								'value_not_equal_to' => 'classic',
						),
				),
				array(
						'type' => 'autocomplete',
						'heading' => esc_html__( 'Categories To Display', 'semona-extension' ),
						'param_name' => 'categories',
						'settings' => array(
								'multiple' => true,
								'min_length' => 1,
								'groups' => true,
								'unique_values' => true,
								'display_inline' => true,
								'delay' => 500,
								'auto_focus' => true,
						),
						'param_holder_class' => 'vc_not-for-custom',
						'description' => esc_html__( 'Enter post categories.', 'semona-extension' ),
				),
				array (
						'type' => 'dropdown',
						'heading' => esc_html__( 'Disable Bottom Border', 'semona-extension' ),
						'param_name' => 'disable_bottom_border',
						'value' => array (
								esc_html__( 'No', 'semona-extension' ) => 'no',
								esc_html__( 'Yes', 'semona-extension' ) => 'yes',
						),
						'admin_label' => true,
				),
				sm_extra_class(), 
		) 
) );

add_filter( 'vc_autocomplete_sm_blog_categories_render', 'sm_blog_categories_vc_autocomplete_render', 10, 1 );
function sm_blog_categories_vc_autocomplete_render( $term ) {
	$terms = get_terms(
			array( 'category' ),
			array(
					'include' => array( $term['value'] ),
					'hide_empty' => false,
			)
	);
	$data = false;
	if ( is_array( $terms ) && 1 === count( $terms ) ) {
		$term = $terms[0];
		$data = array(
				'label' => $term->name,
				'value' => $term->term_id,
		);
	}

	return $data;
}

add_filter( 'vc_autocomplete_sm_blog_categories_callback', 'sm_blog_categories_vc_autocomplete_search', 10, 1 );
function sm_blog_categories_vc_autocomplete_search( $search_string ) {
	$data = array();
	$terms = get_terms(
			array( 'category' ),
			array(
					'search' => $search_string,
					'hide_empty' => false,
			)
	);
	if ( is_array( $terms ) && ! empty( $terms ) ) {
		foreach ( $terms as $t ) {
			if ( is_object( $t ) ) {
				$data[] = array(
						'label' => $t->name,
						'value' => $t->term_id,
				);
			}
		}
	}

	return $data;
}