<?php

function sm_register_shortcode_handler_sm_blog_slider() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_blog_slider extends WPBakeryShortCode {
			protected function outputTitle( $title ) {
				return '';
			}
			function content($atts, $content = null) {
				return sm_blog_slider_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_blog_slider', 'sm_blog_slider_func' );
	}
}

function sm_blog_slider_func( $atts, $content = '' ) {
	$view_params = array(
			'atts' => $atts,
			'content' => $content
	);
	return sm_render_view( 'blog-slider', $view_params );
}

sm_register_shortcode( array (
		'name' => esc_html__( 'Featured Posts Slider', 'semona-extension' ),
		'base' => 'sm_blog_slider',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-blog_slider.png',
		'params' => array(
				array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Maximum Posts', 'semona-extension' ),
						'param_name' => 'max',
						'value' => '',
						'description' => esc_html__( 'Leave it empty for default 5 posts', 'semona-extension' ),
						'admin_label' => true,
				),
				array(
						'type' => 'autocomplete',
						'heading' => esc_html__( 'Categories To Display', 'semona-extension' ),
						'param_name' => 'categories',
						'settings' => array(
								'multiple' => true,
								'min_length' => 1,
								'groups' => true,
								'unique_values' => true,
								'display_inline' => true,
								'delay' => 500,
								'auto_focus' => true,
						),
						'param_holder_class' => 'vc_not-for-custom',
						'description' => esc_html__( 'Enter post categories.', 'semona-extension' ),
				),
				sm_extra_class(), 
		) 
) );

add_filter( 'vc_autocomplete_sm_blog_slider_categories_render', 'sm_blog_slider_categories_vc_autocomplete_render', 10, 1 );
function sm_blog_slider_categories_vc_autocomplete_render( $term ) {
	$terms = get_terms(
			array( 'category' ),
			array(
					'include' => array( $term['value'] ),
					'hide_empty' => false,
			)
	);
	$data = false;
	if ( is_array( $terms ) && 1 === count( $terms ) ) {
		$term = $terms[0];
		$data = array(
				'label' => $term->name,
				'value' => $term->term_id,
		);
	}

	return $data;
}

add_filter( 'vc_autocomplete_sm_blog_slider_categories_callback', 'sm_blog_slider_categories_vc_autocomplete_search', 10, 1 );
function sm_blog_slider_categories_vc_autocomplete_search( $search_string ) {
	$data = array();
	$terms = get_terms(
			array( 'category' ),
			array(
					'search' => $search_string,
					'hide_empty' => false,
			)
	);
	if ( is_array( $terms ) && ! empty( $terms ) ) {
		foreach ( $terms as $t ) {
			if ( is_object( $t ) ) {
				$data[] = array(
						'label' => $t->name,
						'value' => $t->term_id,
				);
			}
		}
	}

	return $data;
}