<?php
/**
 * Semona Shortcode Generator
 */

global $crsg_shortcodes;
$crsg_shortcodes = array();

/* Return shortcodes */
function crsg_shortcodes() {
	global $crsg_shortcodes;
	return $crsg_shortcodes;
}

/* Add shortcode. Accepts vc_map()-styled argument array */
function crsg_register_shortcode( $args ) {
	global $crsg_shortcodes;
	$crsg_shortcodes[$args['base']] = $args;
}

/* Enqueue assets */
add_action( 'admin_init', 'crsg_admin_init' );
function crsg_admin_init() {
	wp_enqueue_style( 'cr-shortcode-generator', SM_PLUGIN_URL . '/inc/shortcode-generator/css/shortcode-generator.css' );
	wp_enqueue_style( 'cr-icon-picker', SM_PLUGIN_URL . '/inc/shortcode-generator/css/iconpicker/jquery.fonticonpicker.min.css' );
	wp_enqueue_style( 'cr-tokenize', SM_PLUGIN_URL . '/inc/shortcode-generator/css/jquery.tokenize.css' );
	
	wp_enqueue_script( 'jquery-livequery', SM_PLUGIN_URL . '/inc/shortcode-generator/js/jquery.livequery.min.js' );
	wp_enqueue_script( 'jquery-fonticonpicker', SM_PLUGIN_URL . '/inc/shortcode-generator/js/jquery.fonticonpicker.min.js' );
	wp_enqueue_script( 'cr-tokenize', SM_PLUGIN_URL . '/inc/shortcode-generator/js/jquery.tokenize.js' );
}

/* Register button */
add_action( 'init', 'crsg_init' );
function crsg_init() {
	if( get_user_option( 'rich_editing' ) == 'true' )
	{
		add_filter( 'mce_external_plugins', 'crsg_add_rich_plugins' );
		add_filter( 'mce_buttons', 'crsg_register_rich_buttons' );
		add_action('wp_ajax_sm_get_autocomplete_suggestion', 'sm_get_autocomplete_suggestion');
	}
}
function crsg_add_rich_plugins() {
	if( is_admin() ) {
		$plugin_array['crsg_button'] = SM_PLUGIN_URL . '/inc/shortcode-generator/js/sg.js';
	}
	return $plugin_array;
}
function crsg_register_rich_buttons( $buttons ) {
	array_push( $buttons, 'crsg_button' );
	return $buttons;
}

/* Output single param body */
function crsg_output_param_html( $param ) {
	if( empty( $param ) || !is_array( $param ) ) {
		return;
	}
	$param_html = SM_PLUGIN_PATH . '/inc/shortcode-generator/params/' . $param['type'] . '.php';
	if( is_file( $param_html ) ) {
		if( !empty( $param['heading'] ) ) {
			echo "<h4>" . $param['heading'] . "</h4>";
		}
		include ( $param_html );
		if( !empty( $param['description'] ) ) {
			echo "<div class='crsg-param-desc'>" . $param['description'] . "</div>";
		}
	}
}

/* Output single param */
function crsg_output_params( $param ) {
	$param_holder_class = array( 'crsg-param-section' );
	if ( !empty( $param['param_holder_class'] ) ) $param_holder_class[] = esc_attr( $param['param_holder_class'] );
	if ( !empty( $param['edit_field_class'] ) )	$param_holder_class[] = $param['edit_field_class'];
	
	$data = '';
	if( !empty( $param['dependency'] ) ) {
		$param_dep = $param['dependency'];
		foreach( $param_dep as $key => $value ) {
			if( $key != 'element' && !is_array( $value ) ) {
				$param_dep[$key] = array( $value );
			}
		}
		$data .= " data-dependency='" . json_encode( $param_dep ) . "'";
	}
	?><div class='<?php echo implode( ' ', $param_holder_class ); ?>'<?php echo ( $data ) ?>><?php
		crsg_output_param_html( $param );
	?></div><?php
}

/* Output single param group */
function crsg_output_param_group( $params, $values, $custom_class = '' ) {
	?>
	<div class='crsg-param-group closed<?php echo ( $custom_class ) ? ( ' ' . $custom_class ) : ''; ?>'>
		<div class='crsg-param-group-controls clearfix'>
			<a href='#' class='crsg-param-group-control move'>
				<i class='fa fa-arrows'></i>
			</a>
			<a href='#' class='crsg-param-group-control delete'>
				<i class='fa fa-trash-o'></i>
			</a>
			<a href='#' class='crsg-param-group-control clone'>
				<i class='fa fa-copy'></i>
			</a>
			<a href='#' class='crsg-param-group-control toggle'>
				<i class='fa fa-caret-down down'></i>
				<i class='fa fa-caret-up up'></i>
			</a>
		</div>
		<div class='crsg-param-group-body'>
			<?php
			foreach( $params as $param ) {
				if( !empty( $values[$param['param_name']] ) ) {
					$param['value'] = $values[$param['param_name']];
				}
				crsg_output_params( $param );
			}
			?>
		</div>
	</div>
	<?php
}

/* Output modal template */
add_action( 'wp_ajax_crsg_popup', 'crsg_popup' );
function crsg_popup() {
	require_once ( 'modal.php' );
	die();
}

/* Move css_animation and el_class params to bottom */
function preprocess_shortcodes() {
	global $crsg_shortcodes;
	foreach( $crsg_shortcodes as $key => $shortcode ) {
		$params = $shortcode['params'];
		$len = count( $params );
		for( $i = 0; $i < $len; $i++ ) {
			$param_name = $params[$i]['param_name'];
			if( $param_name == 'css_animation' || $param_name == 'el_class' ) {
				$param = $params[$i];
				unset( $params[$i] );
				$params[] = $param;
			}
		}
		$crsg_shortcodes[$key]['params'] = $params;
	}
}
preprocess_shortcodes();

/* AutoComplete Ajax Process */

function sm_get_autocomplete_suggestion() {
	$shortcode = $_POST['shortcode'];
	$param_name = $_POST['param'];
	$query = $_POST['query'];

	// Use Filters created for js composer without modification. Filters name can be changed, but each shortcode needs to add the filter again.
	$suggestions = apply_filters( 'vc_autocomplete_' . stripslashes( $shortcode ) . '_' . stripslashes( $param_name ) . '_callback', $query, $shortcode, $param_name );
	
	if ( is_array( $suggestions ) && ! empty( $suggestions ) ) {
		die( json_encode( $suggestions ) );
	}
	die( '' ); // if nothing found..
}