<?php

$label = '';
$title = '';

if ( is_search() ) {
	/* TRANSLATORS: Text before showing the search result. (Front end) */
	$label = esc_html__( 'Search result for', 'theodore' );
	$title = ucfirst( esc_html( get_search_query() ) );
}

if ( is_category() ) {
	/* TRANSLATORS: Text before showing articles on a particular category. (Front end) */
	$label = esc_html__( 'All articles under', 'theodore' );
	$title = single_cat_title( '' , false );
}

if ( is_tag() ) {
	/* TRANSLATORS: Text before showing articles on a particular tag. (Front end) */
	$label = esc_html__( 'All articles under', 'theodore' );
	$title = single_tag_title( '', false );
}

if ( is_author() ) {
	/* TRANSLATORS: Text before showing articles written by a particular author. (Front end) */
	$label = esc_html__( 'Articles by', 'theodore' );
	$title = get_the_author_meta( 'display_name' );
	$url = esc_url( get_the_author_meta( 'url' ) );
}

if ( is_author() ) :
	?>
	<div class="row-container">
		<div class="row index-header half-height has-handler-data"
			data-label="<?php echo esc_html( $label . ' ' . $title ); ?>"
			>
			<div class="column grid-12 align-center">
				<div class="avatar-container" data-name="<?php echo esc_attr( get_the_author_meta( 'display_name' ) ); ?>">
					<?php echo get_avatar( esc_attr( get_the_author_meta( 'email' ) ), 130, '', esc_attr( get_the_author_meta( 'display_name' ) ), null ); ?>
				</div>
				<h2><?php echo the_author_link(); ?></h2>
				<div class="description">
					<?php echo wpautop( esc_html( get_the_author_meta( 'description' ) ) ); ?>
				</div>
			</div>
		</div>
	</div>
	<?php
else :
	if ( $title != '' ) :
		?>
		<div class="row-container index-header">
			<div class="row half-height has-handler-data"
				data-label="<?php echo esc_html( ucwords( $label . ' ' . $title ) ); ?>"
				>
				<div class="column grid-12 align-center">
					<div class="module-big-text">
						<h2><?php echo esc_html( $label ) . ' <span class="title">' . esc_html( ucwords( $title ) ) . '</span>'; ?></h2>
					</div>
					
					<?php if ( is_search() ) : ?>
						<div class="retry-search">
							<?php echo get_search_form(); ?>
						</div>
					<?php endif; ?>
					
				</div>
			</div>
		</div>
		<?php
	endif;
endif;

?>