<?php

global $theodore_tags, $post;

$settings = array();
$settings['theodore_header_style'] = get_option( 'theodore_header_style' );
$settings['theodore_blog_index'] = get_option( 'theodore_blog_index' );

$is_portfolio = 'theodore_portfolio' == get_post_type() ? true : false;

$post_classes = array(
	'row',
	'article-header',
	'has-handler-data'
);

/* TRANSLATORS: Article label on the sidebar handle. Ex: Article / Title of the Post (Front end) */
$article_label = esc_html__('Article', 'theodore');
$title = get_the_title() != '' ? get_the_title() : '#' . $post->ID;
$sidebar_handle_label = ( 'post' == get_post_type() ? $article_label . ' / ' : '' ) . $title;

$categories = $theodore_tags->getTheCategory();
$tags = $theodore_tags->getTheTags();

/* 	Check if theme has settings. This is one way to determine if a post's header is designed
	with the theme meta boxes */
$has_meta_boxes = get_post_meta( $post->ID, 'theodore_text_color', true ) == '' ? false : true;

/* Sidebar background color: 963F0B */
$sidebar_bg = get_post_meta( $post->ID, 'theodore_sidebar_background_color', true );
$sidebar_bg = $sidebar_bg == '' ? '#f9f9f9' : $sidebar_bg;
TheodoreThemeUtils::setStatic( 'sidebar_background_color', $sidebar_bg );

$featured_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'post-thumbnail' );
$featured_image_url = isset( $featured_image_url[0] ) ? $featured_image_url[0] : '';

$has_image_class = $featured_image_url != '' ? 'has-image' : '';
$post_classes[] = esc_attr( $has_image_class );

/* Text color from meta boxes */
if ( $has_meta_boxes ) {
	$text_color_class = 'dark-text';
	if ( 'light' == get_post_meta( $post->ID, 'theodore_text_color', true ) ) {
		$text_color_class = 'light-text';
	}
	$post_classes[] = esc_attr( $text_color_class );
}
else {
	if ( $featured_image_url != '' ) {
		$text_color_class = 'light-text';
	}
	else {
		$text_color_class = 'dark-text';
	}
	$post_classes[] = esc_attr( $text_color_class );
}

/* Cover opacity from meta boxes */
if ( $has_meta_boxes ) {
	$cover_opacity = get_post_meta( $post->ID, 'theodore_cover_opacity', true );
	$opacity_class = '';
	if ( '' !== $cover_opacity ) {
		$opacity_class = 'opacity-' . str_replace( '.', '-', $cover_opacity );
	}
	$post_classes[] = esc_attr( $opacity_class );
}
else {
	if ( $featured_image_url != '' ) {
		$opacity_class = 'opacity-0-2';
	}
	else {
		$opacity_class = '';
	}
	$post_classes[] = esc_attr( $opacity_class );
}

/* Background repeat from meta boxes */
$background_repeat = get_post_meta( $post->ID, 'theodore_background_repeat', true );
$background_repeat = 'yes' == $background_repeat ? 'background-repeat' : '';
$post_classes[] = esc_attr( $background_repeat );

/* Background image attachment from meta boxes */
$background_fixed = ( is_single() || is_page() ) && get_post_meta( $post->ID, 'theodore_background_fixed', true ) == 'yes'
		? 'background-fixed'
		: ''
		;
$post_classes[] = esc_attr( $background_fixed );

if ( is_singular() || $is_portfolio ) {
	/* Row height fetched from meta boxes. */
	$height_class = get_post_meta( $post->ID, 'theodore_full_screen', true ) == 'yes'
		? 'full-height'
		: 'two-thirds-height'
		;
}
else {
	/* Row height fetched from theme settings. */
	$height_class = isset( $settings['theodore_blog_index']['blog_list_item_height'] )
		? $settings['theodore_blog_index']['blog_list_item_height']
		: 'half-height'
		;
}

$post_classes[] = esc_attr( $height_class );

$attach_left = 'attach-left';
if ( is_singular() ) {
	$attach_left = '';
}

if ( 'post' == get_post_type() ) {
	/* Header's text position from theme settings */
	$header_text_position = isset( $settings['theodore_header_style']['post_header_text_position'] ) && $settings['theodore_header_style']['post_header_text_position'] == 'middle'
		? 'align-center'
		: 'valign-bottom ' . $attach_left
		;
}
else {
	/* Header's text position from theme settings */
	$header_text_position = isset( $settings['theodore_header_style']['page_header_text_position'] ) && $settings['theodore_header_style']['page_header_text_position'] == 'middle'
		? 'align-center'
		: 'valign-bottom ' . $attach_left
		;
}

$featured_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'post-thumbnail' );
$featured_image_url = isset( $featured_image_url[0] ) ? esc_url( $featured_image_url[0] ) : '';

?>
<div class="row-container">
	<div id="article-header-<?php echo esc_attr( $post->ID ); ?>" <?php post_class( $post_classes ); ?>
		data-label="<?php echo esc_attr( $sidebar_handle_label ); ?>"
		data-bg-color="<?php echo esc_attr( $sidebar_bg ); ?>"
		data-background-image="<?php echo esc_url( $featured_image_url ); ?>"
		>
		<div class="column grid-12 <?php echo esc_attr( $header_text_position ); ?>">
			
			<div class="featured-image"><?php the_post_thumbnail(); ?></div>
			
			<?php if ( is_sticky() ) : ?>
				
				<?php /* TRANSLATORS: Text label attached to sticky posts. (Front end) */ ?>
				<div class="featured-label"><?php esc_html_e( 'Featured', 'theodore' ); ?></div>
				
			<?php endif; ?>
			
			<?php if ( ! is_singular()  ) : ?>
				
				<h1><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h1>
				
			<?php else: ?>
				
				<h1><?php the_title(); ?></h1>
				
			<?php endif; ?>
			
			<?php if ( has_excerpt() ) : ?>
				
				<div class="subtitle">
					<?php echo wpautop( esc_html( get_the_excerpt() ) ); ?>
				</div>
				
			<?php endif; ?>
			
			<?php if ( ! is_page() && ! $is_portfolio ): ?>
			
				<div class="article-meta"><p>
				
					<?php /* TRANSLATORS: Preposition for author's name. (Front end) */ ?>
					<?php esc_html_e( 'by', 'theodore' ); ?> <?php the_author_posts_link(); ?>
					
					<?php /* TRANSLATORS: Preposition for article's publish date. (Front end) */ ?>
					<?php esc_html_e( 'on', 'theodore' ); ?> <?php echo esc_html( get_the_date( '' ) ); ?>
					
					<?php /* TRANSLATORS: Preposition for article's categories. (Front end) */ ?>
					<?php esc_html_e( 'in', 'theodore' ); ?> <?php echo $categories; ?> <br/>
					
					<?php echo $tags; ?>
				</p></div>
			
			<?php endif; ?>
			
		</div>
	</div>
</div>