<?php

global $total_item;

switch ( $total_item ) {
	case 1:
		$size = 'post-thumbnail';
		break;
	case 2:
		$size = 'large';
		break;
	default:
		$size = 'medium_large';
		break;
}

$medium_featured_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), $size );
$medium_featured_image_url = isset( $medium_featured_image_url[0] ) ? $medium_featured_image_url[0] : '';

$category_array = get_the_category( $post->ID );
$i = 0;
$categories = '';
foreach ( $category_array as $k => $v ) {
	$sep = '';
	if ( $i < count( $category_array ) - 1 ) {
		$sep = ' &middot; ';
	}
	$categories .= '<span class="category">' . esc_html( $category_array[$k]->name ) . '</span>' . $sep;
	$i++;
}

$tag_array = get_the_tags( $post->ID ) ? get_the_tags( $post->ID ) : array();
$tags = '<br />';
foreach ( $tag_array as $k => $v ) {
	$tags .= '#' . esc_html( $tag_array[$k]->name ) . ' ';
}

?>
<div <?php post_class( array( 'item' ) ); ?>>
	<a href="<?php echo esc_url( get_permalink() ); ?>">
		
		<?php if ( is_sticky() ) : ?>
			
			<?php /* TRANSLATORS: Text label attached to sticky posts. (Front end) */ ?>
			<div class="featured-label"><?php esc_html_e( 'Featured', 'theodore' ); ?></div>
			
		<?php endif; ?>
		
		<div class="image">
		
			<?php if ( '' != esc_url( $medium_featured_image_url ) ) : ?>
				<img src="<?php echo esc_url( $medium_featured_image_url ); ?>" alt="<?php the_title(); ?>"/>
			<?php endif; ?>
			
		</div>
		
		<div class="text">
			<div class="meta">
				<span class="date"><?php echo esc_html( get_the_date( '' ) ); ?></span><?php echo $categories . $tags; ?>
			</div>
			<h1 class="title"><?php echo the_title(); ?></h1>
			<div class="read-more tabulated">
				<?php /* TRANSLATORS: Text label to read the full article. (Front end) */ ?>
				<div class="cell"><span><?php esc_html_e( 'Read more', 'theodore' ); ?></span><i class="fa fa-chevron-right"></i></div>
			</div>
		</div>
	</a>
</div>