<?php

global $wpdb, $post;

$date = $post->post_date;
$limit = 3;

$p = $wpdb->get_results( "(	SELECT
								p1.post_title, 
								p1.post_date,
								p1.ID
							FROM 
								" . $wpdb->posts . " p1
							WHERE 
								p1.post_date < '" . $date . "' AND 
								p1.post_type = 'post' AND 
								p1.post_status = 'publish' 
							ORDER by 
								p1.post_date DESC
							LIMIT 
								" . $limit . "
							)
							UNION 
							(
								SELECT 
									p2.post_title, 
									p2.post_date,
									p2.ID 
								FROM 
									" . $wpdb->posts . " p2 
								WHERE 
									p2.post_date > '" . $date . "' AND 
									p2.post_type = 'post' AND 
									p2.post_status = 'publish' 
								ORDER by
									p2.post_date ASC
								LIMIT 
									" . $limit . "
							) 
							ORDER by post_date DESC
							");


$i = 0;
$adjacents = array();
$ids = array();
$total_future_posts = 0;

for( $c = count( $p ); $i < $c; $i++ ) {
	
	if ( $p[$i]->post_date > $date ) {
		$total_future_posts++;
	}
	
	$ids[] = $p[$i]->ID;
	
	if ( count( $ids ) == 4 ) {
		
		if ( $total_future_posts == 3 ) {
			unset($ids[0]);
		}
		else {
			unset($ids[$i]);
		}
		
		break;
	}
	
}

if ( count( $ids ) < 1 ) {
	return;
}

$adjacent_posts = new WP_Query( array(
	'post_type' => 'post',
	'post_status' => 'publish',
	'post__in' => $ids
) );

$cols_class = 'three-cols';
switch ( ( int ) $adjacent_posts->post_count ) {
	case 1:
		$cols_class = 'one-col';
		break;
	case 2:
		$cols_class = 'two-cols';
		break;
}

?>

<?php if ( $adjacent_posts->have_posts() ) : ?>

	<div class="row-container">
		<div class="row has-handler-data"
			data-label="<?php esc_attr_e( 'More Articles', 'theodore' ); ?>"
			data-bg-color="#202020"
			>
			<div class="column grid-12 no-padding">
				<div class="blog-list adjacent-posts <?php echo esc_attr( $cols_class ); ?> clearfix">
					
					<?php
					
					global $total_item;
					
					$total_item = $adjacent_posts->post_count;
					
					$i = 0;
					while ( $adjacent_posts->have_posts() ) {
						$adjacent_posts->the_post();
						get_template_part( 'templates/part', 'blog-grid-item' );
						
						$i++;
						
						if ( $i == 3 ) {
							break;
						}
					}
					
					?>
					
				</div>
			</div>
		</div>
	</div>
	
	<?php wp_reset_postdata(); ?>
<?php endif; ?>