<?php

if ( ! defined( 'THEODORE_PLUGIN_DIR' ) || ! is_callable( array( 'TheodorePluginUtils', 'loadPluginTemplatePart' ) ) ) {
	return;
}

$adjacent_id = 0;
$adjacent = get_next_post();

if ( $adjacent ) {
	$args = array(
		'post_type' => 'theodore_portfolio',
		'p' => $adjacent->ID
	);
}
else {
	/* 	If there's no next post, then it means that it's 
		the last item. Get the first one instead */
	$args = array(
		'post_type' => 'theodore_portfolio',
		'posts_per_page' => 1,
		'order' => 'ASC'
	);
}

$theodore_plugin_utils = new TheodorePluginUtils();
$portfolio = new WP_Query( $args );

?>

<?php if ( $portfolio->have_posts() ) : ?>
	<?php while ( $portfolio->have_posts() ): ?>
		<div class="row-container">
			<div class="row">
				<div class="column no-padding">
					<div class="module-portfolio hide-text-first clearfix">
						
						<?php
						
						global $theodore_portfolio_column, $theodore_portfolio_height, $hide_text_first, $theodore_portfolio_item_bg_image_data;
						
						$portfolio->the_post();
						
						$theodore_portfolio_column = '';
						$theodore_portfolio_height = 'half';
						
						$featured_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'post-thumbnail' );
						$featured_image_url = isset( $featured_image_url[0] ) ? $featured_image_url[0] : '';
						$theodore_portfolio_item_bg_image_data = $featured_image_url;
						
						
						
						echo $theodore_plugin_utils->loadPluginTemplatePart( 'part-portfolio-item' );
						
						?>
						
					</div>
				</div>
			</div>
		</div>
	<?php endwhile; ?>
<?php wp_reset_postdata(); ?>

<?php endif; ?>