<?php

/* Let's get the blog item part and make it the article header (Except it's hidden) */
if ( 'yes' != strtolower( get_post_meta( $post->ID, 'theodore_hide_header', true ) ) ) {
	get_template_part( 'templates/part', 'blog-list-item' );
}

the_content();

wp_link_pages( array(
	'before' => '<div class="row-container"><div class="row page-pagination"><div class="column grid-12 align-center no-top-padding no-bottom-padding"><div class="pagination">',
	'after'  => '</div></div></div></div>',
	'next_or_number' => 'next',
	/* TRANSLATORS: Label for link to next page. (Front end) */
	'nextpagelink'     => esc_html__( 'Next page', 'theodore' ),
	/* TRANSLATORS: Label for link to previous page. (Front end) */
	'previouspagelink' => esc_html__( 'Previous page', 'theodore' )
) );

if ( 'post' === get_post_type() ) {
	
	get_template_part( 'templates/part', 'adjacent-posts' );
	
}

if ( 'theodore_portfolio' === get_post_type() ) {
	
	get_template_part( 'templates/part', 'adjacent-portfolios' );
	
}

?>

<!-- Commenting -->
<?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
	<div class="row-container">
		<div class="row has-handler-data"
			<?php /* TRANSLATORS: Comment label on the sidebar handle. Ex: Comments / Title of the Post (Front end) */; ?>
			data-label="<?php echo esc_attr__('Comments', 'theodore') . ' / ' . get_the_title(); ?>"
			>
			<div class="column commenting grid-12">
				<?php comments_template('', true); ?>
			</div>
		</div>
	</div>
<?php endif; ?>