<div class="row-container">
	<div class="row full-height has-handler-data"
		data-label="<?php echo esc_attr( get_bloginfo( 'site_name' ) ); ?>"
		>
		<div class="column grid-12 align-center">
			
			<?php if ( is_404() ) : ?>
				<?php /* TRANSLATORS: 404 label on the 404 page. (Front end) */ ?>
				<h1><?php esc_html_e( '404', 'theodore' ); ?></h1>
				<?php /* TRANSLATORS: Text to show on 404 page. You can use the [link_to_blog_page] shortcode to make a link to the blog index page (example: "Please try the search below or [link_to_blog_page]browse our latest articles[/link_to_blog_page]") (Front end) */ ?>
				<div class="module-big-text"><p class="align-center"><?php echo str_replace( '[search_keywords]', '"<b>' . ucfirst( esc_attr( get_search_query() ) ) . '</b>"', do_shortcode( esc_html__( "It looks like nothing was found at this location.", 'theodore' ) ) ); ?></p></div>
			<?php endif; ?>
			
			<?php if ( ! is_404() && ! is_search() ): ?>
				<?php /* TRANSLATORS: Text to show when no post. (Front end) */ ?>
				<p class="align-center"><?php esc_html_e( 'No post at the moment.', 'theodore' ); ?></p>
			<?php endif; ?>
			
			<?php if ( is_search() ) : ?>			
				<?php /* TRANSLATORS: Text to show when the search returns nothing. You can use the [link_to_blog_page] shortcode to make a link to the blog index page (example: "Please try the search below or [link_to_blog_page]browse our latest articles[/link_to_blog_page]"). (Front end) */ ?>
				<p class="align-center"><?php echo str_replace( '[search_keywords]', '"<b>' . ucfirst( esc_attr( get_search_query() ) ) . '</b>"', do_shortcode( esc_html__( "Unfortunately there's no content with the keywords [search_keywords]. Please retry the search with a different keywords.", 'theodore' ) ) ); ?></p>
			<?php endif; ?>
			
			<?php if ( is_404() || is_search() ) : ?>
				<div class="retry-search">
					<?php echo get_search_form(); ?>
				</div>
			<?php endif; ?>
				
		</div>
	</div>
</div>