</main>

<?php

$general_settings = get_option( 'theodore_general_settings' );

$widget_column_number = isset( $general_settings['widget_column_number'] ) ? $general_settings['widget_column_number'] : '';
$copyright_text = isset( $general_settings['footer_copyright_text'] ) && $general_settings['footer_copyright_text'] != ''
	? $general_settings['footer_copyright_text']
	: '&copy ' . date( 'Y' ) . ' &nbsp;&middot;&nbsp; <a href="' . esc_url( home_url( '/' ) ) . '">' . esc_html( get_bloginfo( 'site_name' ) ) . '</a>';

switch ( $widget_column_number ) {
	case '1':
		$col_class = 'one-col';
		break;
	case '2':
		$col_class = 'two-cols';
		break;
	case '4':
		$col_class = 'four-cols';
		break;
	default:
		$col_class = 'three-cols';
		break;
}

$footer_custom_content = get_option( 'theodore_footer_custom_content' );
$header_text = isset( $footer_custom_content['header_text'] ) ? $footer_custom_content['header_text'] : '';
$body_text = isset( $footer_custom_content['body_text'] ) ? $footer_custom_content['body_text'] : '';
$link_url = isset( $footer_custom_content['link_url'] ) ? $footer_custom_content['link_url'] : '';
$link_text = isset( $footer_custom_content['link_text'] ) ? $footer_custom_content['link_text'] : '';
$link_as_button = isset( $footer_custom_content['link_as_button'] ) ? $footer_custom_content['link_as_button'] : '';

$link_button_class = $link_as_button == 'yes' ? 'module-button light opaque' : '';

$has_custom_footer_content = ( $header_text != '' || $body_text != '' || $link_url != '' || $link_text != '' ) ? true : false;

?>
<footer id="footer" class="has-handler-data"
	data-label="<?php echo esc_attr( $header_text ) != '' ? esc_attr( $header_text ) : esc_attr( get_bloginfo( 'site_name' ) ); ?>"
	data-bg-color="#111118"
	>
	
	<?php if ( $has_custom_footer_content ) : ?>
	
		<div class="outro custom-section row has-handler-data"
			data-label="<?php echo esc_attr( $header_text ); ?>"
			data-bg-color="#111118"
			>
			<div class="column grid-12 align-center">
				<h1><?php echo esc_html( $header_text ); ?></h1>
				<div class="module-big-text">
					<p><?php echo esc_html( $body_text ); ?></p>
				</div>
				<div class="module-big-text size-2">
					<p><a href="<?php echo esc_url( $link_url ); ?>" class="<?php echo esc_attr( $link_button_class ); ?>"><?php echo esc_html( $link_text ); ?></a></p>
				</div>
			</div>
		</div>
	
	<?php endif; ?>
	
	<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
		
		<div class="row outro widget-container <?php echo esc_attr( $col_class ); ?>">
			<div class="column grid-12 valign-top clearfix">
				<?php dynamic_sidebar(); ?>
			</div>
		</div>
		
	<?php endif; ?>
	
	<div class="copyrighting row" style="background-color: #080808;">
		<div class="column grid-12">
			<?php echo do_shortcode( str_replace( array( '&quot;', '&#039;' ), array( '"', '"' ), esc_html( $copyright_text ) ) ); ?>
		</div>
	</div>
	
</footer>
