<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package theodore
 */

get_header();

$blog_settings = get_option( 'theodore_blog_index' );

if ( have_posts() ) :
	
	$theodore_utils = new TheodoreThemeUtils();
	
	/* If it's a blog index */
	if ( !is_single() && ! is_page()  ) :
		
		get_template_part( 'templates/part', 'header-index' );
		
		$grid_blog_index = isset( $blog_settings['blog_index_type'] ) && $blog_settings['blog_index_type'] == 'grid' ? true : false;
		$grid_blog_col_number = isset( $blog_settings['blog_grid_column_number'] ) && $blog_settings['blog_grid_column_number'] == '2' ? 'two-cols' : 'three-cols';
		$grid_sidebar_label = isset( $blog_settings['blog_grid_sidebar_label'] ) ? $blog_settings['blog_grid_sidebar_label'] : '';
		$grid_sidebar_background_color = isset( $blog_settings['blog_grid_sidebar_background_color'] ) && $blog_settings['blog_grid_sidebar_background_color'] != '' ? $blog_settings['blog_grid_sidebar_background_color'] : '#f4f4f4';
		
		if ( $grid_blog_index ) :
			echo '	<div class="row-container">
						<div class="row default-blog-grid half-height has-handler-data"
							data-label="' . esc_attr( $grid_sidebar_label ) . '"
							data-bg-color="' . esc_attr( $grid_sidebar_background_color ) . '"
							>
							<div class="column grid-12 align-center  thin-top-padding">
								<div class="blog-list ' . esc_attr( $grid_blog_col_number ) . ' clearfix">'
				;
		endif;
	
	endif;
	
	while ( have_posts() ) :
		
		the_post();
		
		if ( is_single() || is_page() ) :
			
			/*
			* Use a specific template for single page
			*/
			get_template_part( 'templates/content', 'single' );
		
		else :
			
			/*
			 * Include the Post-Format-specific template for the content.
			 * If you want to override this in a child theme, then include a file
			 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
			 */
			
			get_template_part( 'templates/content', get_post_format() );
			
		endif;

	endwhile;
	
	/* If it's a blog index */
	if ( !is_single() && ! is_page()  ) :
		
		if ( $grid_blog_index ) {
			echo '</div></div></div></div>'; /* End of grid blog index. */
		}
		
		/* TRANSLATORS: Label to go to the previous page in blog pagination. (Front end) */
		$previous_link = get_previous_posts_link( esc_html__( 'Previous', 'theodore' ) );
		/* TRANSLATORS: Label to go to the next page in blog pagination. (Front end) */
		$next_link = get_next_posts_link( esc_html__( 'Next', 'theodore' ) );
		
		if ( $previous_link || $next_link ) :
			
			$sidebar_background_color = TheodoreThemeUtils::getStatic( 'sidebar_background_color' );
			
			$classes = $grid_blog_index ? 'after-grid' : '';
			
			/* TRANSLATORS: Sidebar text when pagination or adjacent posts appear. (Front end) */
			echo '	<div class="row-container">
						<div class="row has-handler-data" data-label="' . esc_attr__( 'More Articles', 'theodore' ) . '" data-bg-color="' . esc_attr( $sidebar_background_color ) . '" style="background-color: ' . esc_attr( $sidebar_background_color ) . ';">
							<div class="column grid-12 no-padding align-center">
								<div class="pagination ' . $classes . '">' . $previous_link . $next_link . '</div>
							</div>
						</div>
					</div>';
			
		endif;
	
	endif;
	
else :
	
	get_template_part( 'templates/content', 'none' );
	
endif;



get_sidebar();
get_footer();

?>