<?php

class TheodoreThemeUtils {
	
	public static $statics = array();
	
	public static function getStatic ( $key ) {
		$values = self::$statics;
		return isset( $values[$key] ) ? $values[$key] : false;
	}
	
	public static function setStatic ( $key, $value ) {
		$values = self::$statics;
		$values[$key] = $value;
		self::$statics = $values;
	}
	
	public function getContrast ( $hexcolor ) {
		$hexcolor = str_replace( '#', '', $hexcolor );
		$r = hexdec( substr( $hexcolor, 0, 2 ) );
		$g = hexdec( substr( $hexcolor, 2, 2 ) );
		$b = hexdec( substr( $hexcolor, 4, 2 ) );
		
		return ((($r * 299) + ($g * 587) + ($b * 114)) / 1000) >= 128 ? 'dark' : 'light';
	}
	
}

?>