<?php

class TheodoreThemeTags {
	
	/**
	 * Get the formatted categories for a post.
	 *
	 * @param int $post_id The ID of the targeted post.
	 * @return string
	 */
	public function getTheCategory ( $post_id = false ) {
		
		$category_array = get_the_category( $post_id );
		$categories = '';
		$i = 0;
		
		foreach ( $category_array as $k => $v ) {
			
			$category_id = get_cat_ID( $category_array[$k]->name );
			$category_link = get_category_link( $category_id );
			
			$sep = '';
			if ( $i > 0 ) {
				$sep = ', ';
			}
			
			/* TRANSLATORS: Preposition that separate categories. (Front end) */
			$separator_word = esc_html__( 'and' , 'theodore' );

			if ( $i == count( $category_array ) - 1 && count( $category_array ) > 2 ) {
				$sep = ', ' . $separator_word . ' ';
			}
			
			if ( $i == count( $category_array ) - 1 && count( $category_array ) == 2 ) {
				$sep = ' ' . $separator_word . ' ';
			}
			
			$categories .= $sep . '<a href="' . esc_url( $category_link ) . '">' . esc_html( $category_array[$k]->name ) . '</a>';
			
			$i++;
		}
		
		return $categories;
		
	}
	
	/**
	 * Get the formatted tags for a post.
	 *
	 * @param int $post_id The ID of the targeted post.
	 * @return string
	 */
	public function getTheTags ( $post_id = false ) {
		
		$tag_array = get_the_tags( $post_id );
		$tags = '';
		$i = 0;
		
		if ( ! $tag_array ) {
			
			return $tags;
			
		}
		
		foreach ( $tag_array as $k => $v ) {
			
			$tag_link = get_tag_link( $tag_array[$k]->term_id );
			
			$sep = '';
			if ( $i > 0 ) {
				$sep = ', ';
			}
			
			/* TRANSLATORS: Preposition that separate categories. (Front end) */
			$separator_word = esc_html__( 'and' , 'theodore' );
			
			if ( $i == count( $tag_array ) - 1 && count( $tag_array ) > 2 ) {
				$sep = ', ' . $separator_word . ' ';
			}
			
			if ( $i == count( $tag_array ) - 1 && count( $tag_array ) == 2 ) {
				$sep = ' ' . $separator_word . ' ';
			}
			
			$tags .= $sep . '<a href="' . esc_url( $tag_link ) . '">#' . esc_html( $tag_array[$k]->name ) . '</a>';
			
			$i++;
		}
		
		return $tags;
		
	}
	
}

?>