<?php

class TheodoreThemeSettings {
	
	private $ts;
	
	public function __construct () {
		
		$this->ts = new TheodoreThemeSettingsAPI();
		$this->ts->setSlug( 'theodore_theme_settings' );
		/* TRANSLATORS: Page title on Theodore Setting page. (Back end) */
		$this->ts->setPageTitle( esc_html__( 'Theodore Theme Settings', 'theodore' ) );
		/* TRANSLATORS: Sub-menu title under the 'Appearance' menu linking to Theodore Settings page. (Back end) */
		$this->ts->setMenuTitle( esc_html__( 'Theodore Settings', 'theodore' ) );
		
		$this->ts->setData( array(
			'theodore_site_logo' => array(
				/* TRANSLATORS: Section title on settings page. (Back end) */
				'title' => esc_html__( 'Site Logo', 'theodore' ),
				/* TRANSLATORS: Section description on settings page. (Back end) */
				'description' => esc_html__( 'Site logo can have two images. The first is used as default. The other one, if provided, is used when the sidebar background is considered dark.', 'theodore' ),
				'fields' => array(
					array(
						'id' => 'logo_default',
						/* TRANSLATORS: Text label to set logo image on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Default Logo image', 'theodore' ),
						'type' => 'media_url'
					)
					,
					array(
						'id' => 'logo_light',
						/* TRANSLATORS: Text label to set logo image on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Light Logo image', 'theodore' ),
						'type' => 'media_url'
					)
				)
			)
			,
			'theodore_menu_container' => array(
				/* TRANSLATORS: Section title on settings page for navigation options. (Back end) */
				'title' => esc_html__( 'Navigation Area', 'theodore' ),
				/* TRANSLATORS: Section description on settings page for navigation options. (Back end) */
				'description' => esc_html__( 'Navigation area style can be viewed when user clicks the sidebar.', 'theodore' ),
				'fields' => array(
					array(
						'id' => 'sidebar_background_color',
						/* TRANSLATORS: Text label to set sidebar background color on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Sidebar Background Color', 'theodore' ),
						'type' => 'text',
						'maxlength' => '7',
						'size' => '7',
						/* TRANSLATORS: Description for default sidebar background color on the Theodore Settings page. (Back end) */
						'description' => esc_html__( 'Use hexadecimal value. Example: #ff9900', 'theodore' )
					)
					,
					array(
						'id' => 'menu_background_image',
						/* TRANSLATORS: Text label to set background image for navigation area on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Background Image', 'theodore' ),
						'type' => 'media_url'
					)
					,
					array(
						'id' => 'menu_cover_opacity',
						/* TRANSLATORS: Text label to set cover opacity for navigation area on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Cover Opacity', 'theodore' ),
						'type' => 'select',
						'options' => array (
							'0' => esc_html__( 'None', 'theodore' ),
							'0.1' => esc_html__( '0.1', 'theodore' ),
							'0.2' => esc_html__( '0.2', 'theodore' ),
							'0.3' => esc_html__( '0.3', 'theodore' ),
							'0.4' => esc_html__( '0.4', 'theodore' ),
							'0.5' => esc_html__( '0.5', 'theodore' ),
							'0.6' => esc_html__( '0.6', 'theodore' ),
							'0.7' => esc_html__( '0.7', 'theodore' ),
							'0.8' => esc_html__( '0.8', 'theodore' ),
							'0.9' => esc_html__( '0.9', 'theodore' )
						)
					)
				)
			)
			,
			'theodore_header_style' => array(
				/* TRANSLATORS: Section title on settings page. (Back end) */
				'title' => esc_html__( 'General Header Style', 'theodore' ),
				/* TRANSLATORS: Section description on settings page. (Back end) */
				'description' => esc_html__( 'These general styles are used to maintain consistency across posts and pages.', 'theodore' ),
				'fields' => array(
					array(
						'id' => 'post_header_text_position',
						/* TRANSLATORS: Text label to set the position of post header text. (Back end) */
						'label' => esc_html__( 'Post header text position', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Text value to set the position of post header text to Bottom Left. (Back end) */
							'bottom-left' => esc_html__( 'Bottom Left', 'theodore' ),
							/* TRANSLATORS: Text value to set the position of post header text to Middle. (Back end) */
							'middle' => esc_html__( 'Middle', 'theodore' )
						)
					)
					,
					array(
						'id' => 'page_header_text_position',
						/* TRANSLATORS: Text label to set the position of page header text. (Back end) */
						'label' => esc_html__( 'Page header text position', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Text value to set the position of page header text to Bottom Left. (Back end) */
							'bottom-left' => esc_html__( 'Bottom Left', 'theodore' ),
							/* TRANSLATORS: Text value to set the position of page header text to Middle. (Back end) */
							'middle' => esc_html__( 'Middle', 'theodore' )
						)
					)
				)
			)
			,
			'theodore_footer_custom_content' => array(
				/* TRANSLATORS: Section title on settings page. (Back end) */
				'title' => esc_html__( 'Footer Custom Content', 'theodore' ),
				/* TRANSLATORS: Section description on settings page. (Back end) */
				'description' => esc_html__( 'The following custom contents will be shown at the bottom of every page.', 'theodore' ),
				'fields' => array(
					array(
						'id' => 'header_text',
						/* TRANSLATORS: Text label to set the header text of custom footer content. (Back end) */
						'label' => esc_html__( 'Header Text', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'body_text',
						/* TRANSLATORS: Text label to set the body text of custom footer content. (Back end) */
						'label' => esc_html__( 'Body Text', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'link_url',
						/* TRANSLATORS: Text label to set the link URL of custom footer content. (Back end) */
						'label' => esc_html__( 'Link URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'link_text',
						/* TRANSLATORS: Text label to set the link text of custom footer content. (Back end) */
						'label' => esc_html__( 'Link Text', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'link_as_button',
						/* TRANSLATORS: Text label whether to set the link of custom footer content as a button. (Back end) */
						'label' => esc_html__( 'Set link as a button', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Text value to unset the link of custom footer content as a button. (Back end) */
							'no' => esc_html__( 'No', 'theodore' ),
							/* TRANSLATORS: Text value to set the link of custom footer content as a button. (Back end) */
							'yes' => esc_html__( 'Yes', 'theodore' )
						)
					)
				)
			)
			,
			'theodore_blog_index' => array (
				/* TRANSLATORS: Section title on settings page. (Back end) */
				'title' => esc_html__( 'Blog Index', 'theodore' ),
				'fields' => array(
					array(
						'id' => 'blog_index_type',
						/* TRANSLATORS: Text label to set whether to repeat the background image on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Blog index type', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Text value to set the blog index type to 'List'. (Back end) */
							'list' => esc_html__( 'List', 'theodore' ),
							/* TRANSLATORS: Text value to set the blog index type to 'Grid'. (Back end) */
							'grid' => esc_html__( 'Grid', 'theodore' )
						)
					)
					,
					array(
						'id' => 'blog_list_item_height',
						/* TRANSLATORS: Text label to choose the opaqueness of the header cover on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Blog list item height', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Text value to set the blog list item height to auto. (Back end) */
							'auto' => esc_html__( 'Auto', 'theodore' ),
							/* TRANSLATORS: Text value to set the blog list item to one third of the screen height. (Back end) */
							'one-third-height' => esc_html__( 'One third of the screen height', 'theodore' ),
							/* TRANSLATORS: Text value to set the blog list item to half the screen height. (Back end) */
							'half-height' => esc_html__( 'Half of the screen height', 'theodore' ),
							/* TRANSLATORS: Text value to set the blog list item to two thirds of the screen height. (Back end) */
							'two-thirds-height' => esc_html__( 'Two thirds of the screen height', 'theodore' ),
							/* TRANSLATORS: Text value to set the blog list item to full height. (Back end) */
							'full-height' => esc_html__( 'Full height', 'theodore' )
						),
						/* TRANSLATORS: Description for 'Blog list item height' in theme settings. (Back end) */
						'description' => esc_html__( 'This will only work if the blog index type is list', 'theodore' )
					)
					,
					array(
						'id' => 'blog_grid_column_number',
						/* TRANSLATORS: Text label to set whether to repeat the background image on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Blog grid column number', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Number set the blog grid column number to 2. (Back end) */
							'2' => esc_html__( '2', 'theodore' ),
							/* TRANSLATORS: Number set the blog grid column number to 3. (Back end) */
							'3' => esc_html__( '3', 'theodore' )
						),
						/* TRANSLATORS: Description for 'Blog grid column number' in theme settings. (Back end) */
						'description' => esc_html__( 'This will only work if the blog index type is grid', 'theodore' )
					)
					,
					array(
						'id' => 'blog_grid_sidebar_label',
						/* TRANSLATORS: Text label to set the sidebar label when blog index type is grid on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Blog grid sidebar label', 'theodore' ),
						'type' => 'text',
						/* TRANSLATORS: Description for 'Blog grid sidebar label' in theme settings. (Back end) */
						'description' => esc_html__( 'This will only work if the blog index type is grid', 'theodore' )
					)
					,
					array(
						'id' => 'blog_grid_sidebar_background_color',
						/* TRANSLATORS: Text label to set default sidebar background color on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Sidebar Default Background Color', 'theodore' ),
						'type' => 'text',
						'maxlength' => '7',
						'size' => '7',
						/* TRANSLATORS: Description for default sidebar background color on the Theodore Settings page. (Back end) */
						'description' => esc_html__( 'This will only work if the blog index type is grid. Use hexadecimal value. Example: #ff9900', 'theodore' )
					)
				)
			)
			,
			'theodore_social_media' => array(
				/* TRANSLATORS: Section title on settings page for social media links. (Back end) */
				'title' => esc_html__( 'Social Media Links', 'theodore' ),
				'fields' => array (
					array(
						'id' => 'twitter_url',
						/* TRANSLATORS: Text label to set Twitter URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Twitter URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'instagram_url',
						/* TRANSLATORS: Text label to set Instagram URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Instagram URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'facebook_url',
						/* TRANSLATORS: Text label to set Facebook URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Facebook URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'google_url',
						/* TRANSLATORS: Text label to set Google URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Google URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'dribbble_url',
						/* TRANSLATORS: Text label to set Dribbble URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Dribbble URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'github_url',
						/* TRANSLATORS: Text label to set Github URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Github URL', 'theodore' ),
						'type' => 'text'
					)
					,
					array(
						'id' => 'linkedin_url',
						/* TRANSLATORS: Text label to set Linkedin URL on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Linkedin URL', 'theodore' ),
						'type' => 'text'
					)
				)
			)
			,
			'theodore_general_settings' => array(
				/* TRANSLATORS: Section title on settings page. (Back end) */
				'title' => esc_html__( 'General Settings', 'theodore' ),
				'fields' => array(
					array(
						'id' => 'portfolio_slug',
						/* TRANSLATORS: Text label to set portfolio slug on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Portfolio Slug', 'theodore' ),
						'type' => 'text',
						/* TRANSLATORS: Inline text below the 'Portfolio slug' input to tell what to do after editing the slug. (Back end) */
						'description' => esc_html__( 'Please refresh the permalinks after you edited this field.', 'theodore' )
					)
					,
					array(
						'id' => 'widget_column_number',
						/* TRANSLATORS: Text label to set custom CSS on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Widget Column Number', 'theodore' ),
						'type' => 'select',
						'options' => array(
							/* TRANSLATORS: Text value to set the widget column number to 2. (Back end) */
							'2' => esc_html__( '2', 'theodore' ),
							/* TRANSLATORS: Text value to set the widget column number to 3. (Back end) */
							'3' => esc_html__( '3', 'theodore' ),
							/* TRANSLATORS: Text value to set the widget column number to 4. (Back end) */
							'4' => esc_html__( '4', 'theodore' ),
						),
					)
					,
					array(
						'id' => 'footer_copyright_text',
						/* TRANSLATORS: Text label to set footer copyright text on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Copyright Text', 'theodore' ),
						'type' => 'text',
						/* TRANSLATORS: Description for footer copyright text on the Theodore Settings page. (Back end) */
						'description' => esc_html__( 'The text will be shown at the footer.', 'theodore')
					)
					,
					array(
						'id' => 'custom_css',
						/* TRANSLATORS: Text label to set custom CSS on the Theodore Settings page. (Back end) */
						'label' => esc_html__( 'Custom CSS', 'theodore' ),
						'type' => 'code_editor'
					)
					,
					array(
						'id' => 'custom_css_import_urls',
						'label' => '',
						'type' => 'hidden'
					)
				)
			)
		) );
		$this->ts->execute();
		
		add_action( 'admin_init', array( $this, 'adminInit' ) );
		
	}
	
	private function extractCSSURLs ( $text ) {
		$urls = array();
 
		$url_pattern     = '(([^\\\\\'", \(\)]*(\\\\.)?)+)';
		$urlfunc_pattern = 'url\(\s*[\'"]?' . $url_pattern . '[\'"]?\s*\)';
		$pattern         = '/(' .
			 '(@import\s*[\'"]' . $url_pattern     . '[\'"])' .
			'|(@import\s*'      . $urlfunc_pattern . ')'      .
			'|('                . $urlfunc_pattern . ')'      .  ')/iu';
		
		
		if ( !preg_match_all( $pattern, $text, $matches ) ) {
			return $urls;
		}
	 
		/*
		@import '...'
		@import "..."
		*/
		foreach ( $matches[3] as $match ) {
			if ( !empty($match) ) {
				$urls['import'][] = preg_replace( '/\\\\(.)/u', '\\1', $match );
			}
		}
	 
		/*
		@import url(...)
		@import url('...')
		@import url("...")
		*/
		foreach ( $matches[7] as $match ) {
			if ( !empty($match) ) {
				$urls['import'][] = preg_replace( '/\\\\(.)/u', '\\1', $match );
			}
		}
	 
		/*
		url(...)
		url('...')
		url("...")
		*/
		foreach ( $matches[11] as $match ) {
			if ( !empty($match) ) {
				$urls['property'][] = preg_replace( '/\\\\(.)/u', '\\1', $match );
			}
		}
		
		return $urls;
	}
	
	public function adminInit () {
		
		if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] == 'true' ) {
			
			$general_settings = get_option( 'theodore_general_settings' );
			$custom_css = isset( $general_settings['custom_css'] ) ? $general_settings['custom_css'] : '';
			$urls = $this->extractCSSURLs( $custom_css );
			
			if ( isset( $urls['import'] ) && count( $urls['import'] ) > 0 ) {
				$general_settings['custom_css_import_urls'] = json_encode( $urls['import'] );
				update_option( 'theodore_general_settings', $general_settings );				
			}
		}
	
	}

}

?>