<?php

/* Adds meta box for posts */

class TheodoreThemeMetaBoxes {
	
	/**
	 * Hook the function for adding and saving the meta boxes on object creation. 
	 */
	public function __construct () {
		
		if ( !is_admin() ) {
			return false;
		}
		
		add_action( 'add_meta_boxes', array( $this, 'addMetaBox' ) );
		add_action( 'save_post', array( $this, 'save' ) );
		
	}
	
	/**
	 * Adds boxes to the main column on the Post, Page, and Portfolio edit screens.
	 * 
	 * @param string $post_type
	 */
	public function addMetaBox ( $post_type ) {
		/* limit meta box to certain post types */
		$post_types = array( 'post', 'page', 'theodore_portfolio' );
		if ( in_array( $post_type, $post_types ) ) {
			
			add_meta_box(
				'theodore_header_style'
				/* TRANSLATORS: Title for header block style in meta boxes. (Back end) */
				, esc_html__( 'Header Block', 'theodore' )
				, array( $this, 'renderHeaderBlock' )
				, $post_type
			);
		}
	}
	
	/**
	 * Render meta box content for all post type in admin area when creating or editing any post
	 *
	 * @param WP_Post $post The post object.
	 */
	public function renderHeaderBlock ( $post ) {
		wp_nonce_field( 'theodore_meta_boxes', 'theodore_meta_boxes_nonce' );
		
		/* Use get_post_meta() to retrieve existing values from the database. */
		
		$hide_header = esc_attr( get_post_meta( $post->ID, 'theodore_hide_header', true ) );
		$cover_opacity = esc_attr( get_post_meta( $post->ID, 'theodore_cover_opacity', true ) );
		$cover_opacity = $cover_opacity == '' ? '0.2' : $cover_opacity;
		$background_repeat = esc_attr( get_post_meta( $post->ID, 'theodore_background_repeat', true ) );
		$background_fixed = esc_attr( get_post_meta( $post->ID, 'theodore_background_fixed', true ) );
		$full_screen = esc_attr( get_post_meta( $post->ID, 'theodore_full_screen', true ) );
		$sidebar_background_color = esc_attr( get_post_meta( $post->ID, 'theodore_sidebar_background_color', true ) );
		$text_color = esc_attr( get_post_meta( $post->ID, 'theodore_text_color', true ) );
		
		?>
		
		<?php if ( 'page' == get_current_screen()->id || 'theodore_portfolio' == get_current_screen()->id ): ?>
		<div id="hide-header-container">
			<p>
				<label for="theodore_hide_header">
					<input type="checkbox" <?php echo $hide_header == 'yes' ? 'checked="checked"' : ''; ?> id="theodore_hide_header" name="theodore_hide_header" value="yes">
					<?php /* TRANSLATORS: Label inside the header block meta-box to hide the header. (Back end) */ ?>
					<?php esc_html_e( 'Hide header block.', 'theodore' ); ?>
				</label>
			</p>
		</div>
		<?php endif; ?>
		
		<div id="mhs-container" class="clearfix">
			<div id="theodore-header-preview" class="header-preview">
				<?php /* TRANSLATORS: Default text for the dummy title example on the preview box. (Back end) */ ?>
				<span class="title"><?php esc_html_e('Dummy Title for Preview', 'theodore' ); ?></span>
				<?php if ( get_current_screen()->id == 'post' ): ?>
					<?php /* TRANSLATORS: Preposition for author's name on the preview box. (Back end) */ ?>
					<div class="meta"><?php esc_html_e( 'by ', 'theodore' ); ?> <span id="theodore-author-name"></span>
					<?php /* TRANSLATORS: Preposition for article publish date on the preview box. (Back end) */ ?>
					<?php esc_html_e( 'on ', 'theodore' ); ?> <span id="theodore-todays-date"></span><br>
					<?php /* TRANSLATORS: Default text for the dummy categories example on the preview box. (Back end) */ ?>
					<?php esc_html_e( 'in Design and Inspiration', 'theodore' ); ?></div>
				<?php endif; ?>
				<span class="cover"></span>
				<span class="refresh"><i class="fa fa-refresh"></i></span>
			</div>
			<p class="item">
				
				<?php /* TRANSLATORS: Text label to change the header cover opacity of the header block. (Back end) */ ?>
				<label for="theodore_cover_opacity"><?php esc_html_e( 'Cover Opacity', 'theodore' ); ?></label><br>
				<select id="theodore_cover_opacity" name="theodore_cover_opacity">
					<?php /* TRANSLATORS: Text value to change the header cover opacity to 'none'. (Back end) */ ?>
					<option value="0" <?php echo $cover_opacity == '0' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'None', 'theodore' ); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.1'. (Back end) */ ?>
					<option value="0.1" <?php echo $cover_opacity == '0.1' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.1', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.2'. (Back end) */ ?>
					<option value="0.2" <?php echo $cover_opacity == '0.2' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.2', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.3'. (Back end) */ ?>
					<option value="0.3" <?php echo $cover_opacity == '0.3' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.3', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.4'. (Back end) */ ?>
					<option value="0.4" <?php echo $cover_opacity == '0.4' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.4', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.5'. (Back end) */ ?>
					<option value="0.5" <?php echo $cover_opacity == '0.5' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.5', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.6'. (Back end) */ ?>
					<option value="0.6" <?php echo $cover_opacity == '0.6' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.6', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.7'. (Back end) */ ?>
					<option value="0.7" <?php echo $cover_opacity == '0.7' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.7', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.8'. (Back end) */ ?>
					<option value="0.8" <?php echo $cover_opacity == '0.8' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.8', 'theodore'); ?></option>
					<?php /* TRANSLATORS: Text value to change the header cover opacity to '0.9'. (Back end) */ ?>
					<option value="0.9" <?php echo $cover_opacity == '0.9' ? 'selected="selected"' : ''; ?>><?php esc_html_e( '0.9', 'theodore'); ?></option>
				</select>
			</p>
			
			<p class="item">
				<?php /* TRANSLATORS: Text label to change the background repeat on the header block. (Back end) */ ?>
				<label for="theodore_background_repeat"><?php esc_html_e( 'Repeat Bg Image', 'theodore' ); ?></label><br>
				<select id="theodore_background_repeat" name="theodore_background_repeat">
					<?php /* TRANSLATORS: Option text with value 'No'. (Back end) */ ?>
					<option value="no" <?php echo $background_repeat == 'no' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'No', 'theodore' ); ?></option>
					<?php /* TRANSLATORS: Option text with value 'Yes'. (Back end) */ ?>
					<option value="yes" <?php echo $background_repeat == 'yes' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Yes', 'theodore' ); ?></option>
				</select>
			</p>
			<p class="item">
				<?php /* TRANSLATORS: Text label to set the header background fixed on scroll. (Back end) */ ?>
				<label for="theodore_background_fixed"><?php esc_html_e( 'Fix Bg Image', 'theodore' ); ?></label><br>
				<select id="theodore_background_fixed" name="theodore_background_fixed">
					<?php /* TRANSLATORS: Option text with value 'No'. (Back end) */ ?>
					<option value="no" <?php echo $background_fixed == 'no' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'No', 'theodore' ); ?></option>
					<?php /* TRANSLATORS: Option text with value 'Yes'. (Back end) */ ?>
					<option value="yes" <?php echo $background_fixed == 'yes' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Yes', 'theodore' ); ?></option>
				</select>
			</p>
			<p class="item">
				<?php /* TRANSLATORS: Text label to set the block header to full-screen. (Back end) */ ?>
				<label for="theodore_full_screen"><?php esc_html_e( 'Full Screen', 'theodore' ); ?></label><br>
				<select id="theodore_full_screen" name="theodore_full_screen">
					<option value="no" <?php echo $full_screen == 'no' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'No', 'theodore' ); ?></option>
					<option value="yes" <?php echo $full_screen == 'yes' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Yes', 'theodore' ); ?></option>
				</select>
			</p>
			<p class="item">
				<?php /* TRANSLATORS: Text label to set the text color. (Back end) */ ?>
				<label for="theodore_text_color"><?php esc_html_e( 'Text Color', 'theodore' ); ?></label><br>
				<select id="theodore_text_color" name="theodore_text_color">
					<?php /* TRANSLATORS: Option text with value 'Dark'. (Back end) */ ?>
					<option value="dark" <?php echo $text_color == 'dark' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Dark', 'theodore' ); ?></option>
					<?php /* TRANSLATORS: Option text with value 'Light'. (Back end) */ ?>
					<option value="light" <?php echo $text_color == 'light' ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Light', 'theodore' ); ?></option>
				</select>
			</p>
			<p class="item">
				<?php /* TRANSLATORS: Text label to set the sidebar background color. (Back end) */ ?>
				<label for="theodore_sidebar_background_color"><?php esc_html_e( 'Sidebar Bg Color', 'theodore' ); ?></label><br>
				<input type="text" id="theodore_sidebar_background_color" name="theodore_sidebar_background_color" value="<?php echo $sidebar_background_color; ?>" autocomplete="true" maxlength="7" size="7" />
			</p>
		</div>
		<div class="clearfix"></div>
		<?php
	}
	
	/**
	 * Save the meta when the post is saved.
	 *
	 * @param int $post_id The ID of the post being saved.
	 */
	public function save ($post_id) {
		/*
		 * We need to verify this came from our screen and with proper authorization,
		 * because save_post can be triggered at other times.
		 */
		
		/* Check if our nonce is set. */
		if ( ! isset( $_POST['theodore_meta_boxes_nonce'] ) ) {
			return $post_id;
		}
		
		$nonce = $_POST['theodore_meta_boxes_nonce'];
		
		/* Verify that the nonce is valid. */
		if ( ! wp_verify_nonce( $nonce, 'theodore_meta_boxes' ) ) {
			return $post_id;
		}
		
		/**
		 * If this is an autosave, our form has not been submitted,
		 * so we don't want to do anything.
		 */
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		
		/* Check the user's permissions. */
		if ( 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return $post_id;
			}
		}
		else {
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
		
		/* OK, its safe for us to save the data now. */
		
		/* Sanitize the user input. */
		
		if ( 'page' == get_current_screen()->id || 'theodore_portfolio' == get_current_screen()->id ) {
			$hide_header = isset( $_POST['theodore_hide_header'] ) ? esc_attr( $_POST['theodore_hide_header'] ) : '';
		}
		
		$cover_opacity = esc_attr( $_POST['theodore_cover_opacity'] );
		$background_repeat = esc_attr( $_POST['theodore_background_repeat'] );
		$background_fixed = esc_attr( $_POST['theodore_background_fixed'] );
		$full_screen = esc_attr( $_POST['theodore_full_screen'] );
		$sidebar_background_color = esc_attr( $_POST['theodore_sidebar_background_color'] );
		$text_color = esc_attr( $_POST['theodore_text_color'] );
		
		/* Update the meta field. */
		
		if ( 'page' == get_current_screen()->id || 'theodore_portfolio' == get_current_screen()->id ) {
			update_post_meta($post_id, 'theodore_hide_header', $hide_header);
		}
		
		update_post_meta($post_id, 'theodore_cover_opacity', $cover_opacity);
		update_post_meta($post_id, 'theodore_background_repeat', $background_repeat);
		update_post_meta($post_id, 'theodore_background_fixed', $background_fixed);
		update_post_meta($post_id, 'theodore_full_screen', $full_screen);
		update_post_meta($post_id, 'theodore_sidebar_background_color', $sidebar_background_color);
		update_post_meta($post_id, 'theodore_text_color', $text_color);
		
	}
	
}

?>