<?php

class TheodoreThemeInit {
	
	public function __construct () {
		
		$this->getCSS();
		
		add_action( 'after_setup_theme', array( $this, 'afterSetupTheme' ) );
		add_action( 'widgets_init', array( $this, 'widgetsInit' ) );
		
		/* 	I read somewhere that it's a good idea to have this line of 
			code somewhere in the theme */
		header( 'X-UA-Compatible: IE=edge,chrome=1' );
		
		if ( is_admin() ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'adminEnqueueScripts' ) );
			add_action( 'adminInit', array( $this, 'adminInit' ) );
		}
		else {
			add_action( 'wp_enqueue_scripts', array( $this, 'wpEnqueueScripts' ) );
		}
		
		add_filter( 'excerpt_length', array( $this, 'customExcerptLength' ), 999 );
		
		add_filter('image_size_names_choose', array($this, 'imageSizeNamesChoose'));
		add_image_size('theodore-full-layout-width', 1920);
	}
	
	public function afterSetupTheme () {
		
		/*	Make theme available for translation.
			Translations can be filed in the /languages/ directory.
			if you're building a theme based on Theodore, use a find and replace
			to change 'theodore' to the name of your theme in all the template files.*/
		load_theme_textdomain( 'theodore', get_template_directory() . '/languages' );

		/* 	Add default posts and comments RSS feed links to head. */
		add_theme_support( 'automatic-feed-links' );
		
		/*	Let WordPress manage the document title.
			By adding theme support, we declare that this theme does not use a
			hard-coded <title> tag in the document head, and expect WordPress to
			provide it for us.*/
		add_theme_support( 'title-tag' );
		
		/*	Enable support for Post Thumbnails on posts and pages.
			@link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
			*/
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1920 );
		
		/* 	This theme uses wp_nav_menu() in one location. */
		register_nav_menus( array(
			/* TRANSLATORS: Menu name for primary location. (Back end) */
			'primary' => esc_html__( 'Primary', 'theodore' ),
		) );
		
		/*	Switch default core markup for search form, comment form, and comments
			to output valid HTML5.*/
		add_theme_support( 'html5', array(
			'search-form',
			/*	Setting comment-form to html5 will add the novalidate attribute
				to the form element which will ignore the required attribute.*/
				
			'comment-list',
			'gallery',
			'caption',
		) );
		
		/**
		 * Enables the Excerpt meta box in Page edit screen.
		 */
		add_post_type_support( 'page', 'excerpt' );
		
		/*	Set the content width in pixels, based on the theme's design and stylesheet.
			Priority 0 to make it available to lower priority callbacks.
			@global int $content_width 
			*/
		$GLOBALS['content_width'] = apply_filters( 'theodore_content_width', 1920 );
		
	}
	
	public function widgetsInit () {
		
		register_sidebar( array (
			/* TRANSLATORS: Sidebar name when registering the sidebar on the back-end. */
			'name'          => esc_html__( 'Bottom Widgets', 'theodore' ),
			'id'            => 'sidebar-1',
			'before_widget' => '<div class="widget %2$s" id="%1$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title"><span>',
			'after_title'   => '</span></h3>',
		) );
		
	}
	
	public function customExcerptLength( $length ) {
		return 25;
	}
	
	public function prefixFontsURL () {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = '';
		
		/* TRANSLATORS: If there are characters in your language that are not supported by this font, translate this to 'lato-off'. Do not translate into your own language. */
		if ( 'poppins-off' !== esc_html__( 'poppins-on', 'theodore' ) ) {
			$fonts[] = 'Poppins:300,400,500,600,700';
		}
		
		if ( $fonts ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $fonts ) ),
				'subset' => urlencode( $subsets ),
			), 'https://fonts.googleapis.com/css' );
		}
		
		return $fonts_url;
	}
	
	public function wpEnqueueScripts () {
		
		wp_enqueue_style( 'theodore-google-fonts', $this->prefixFontsURL(), array(), null );
		wp_enqueue_style( 'theodore-style', get_stylesheet_uri() );
		wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css' );
		
		
		$general_settings = get_option( 'theodore_general_settings' );
		$custom_css_import_urls = isset( $general_settings['custom_css_import_urls'] ) 
			? json_decode( $general_settings['custom_css_import_urls'] )
			: false;
		
		if ( is_array( $custom_css_import_urls ) ) {
			$inc = 0;
			foreach ( $custom_css_import_urls as $url ) {
				wp_enqueue_style( 'theodore-custom-css-import-url-' . $inc++, $url );
			}
		}
		
		wp_enqueue_script( 'jquery-imagesloaded', get_template_directory_uri() . '/assets/js/vendor/imagesloaded.pkgd.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-color', get_template_directory_uri() . '/assets/js/vendor/jquery.color.min.js', array( 'jquery' ), false, true );
		
		wp_enqueue_script( 'theodore-main', get_template_directory_uri() . '/assets/js/main.js', array( 'jquery' ), false, true );
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		/* Get custom css */
		wp_enqueue_style( 'theodore-custom-style', esc_url( home_url( '/' ) ) . '?theodore_get_file=custom_style' );
	}
	
	public function adminEnqueueScripts ( $hook ) {
		
		$pages = array(
			'post.php',
			'post-new.php',
			'appearance_page_theodore_theme_settings',
			'profile.php',
			'user-edit.php',
			'widgets.php'
		);
		
		if( !in_array( $hook, $pages ) ) {
			return;
		}
		
		
		wp_enqueue_media();
		
		wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css' );
		wp_enqueue_style( 'theodore-theme-admin', get_template_directory_uri() . '/assets/css/admin.css' );
		wp_enqueue_script( 'theodore-theme-admin', get_template_directory_uri() . '/assets/js/admin.js', array( 'jquery', 'wp-color-picker' ), '1', false );
		
		if ( 'appearance_page_theodore_theme_settings' == $hook ) {
			wp_enqueue_script( 'theodore-ace', get_template_directory_uri() . '/assets/js/vendor/ace.js' );
			wp_enqueue_script( 'theodore-ace-mode-css', get_template_directory_uri() . '/assets/js/vendor/mode-css.js' );
			wp_enqueue_script( 'theodore-ace-worker-css', get_template_directory_uri() . '/assets/js/vendor/worker-css.js' );
			wp_enqueue_script( 'theodore-css-beautify', get_template_directory_uri() . '/assets/js/vendor/cssbeautify.js' );
		}
		
	}
	
	public function adminInit () {
		add_editor_style( 'assets/css/editor-style.css' );
	}
	
	/**
	 * Add a custom size to Attachment Display Settings in media uploader
	 *
	 * @param mixed $sizes
	 */
	public function imageSizeNamesChoose ($sizes) {
		$custom_sizes = array(
			/* TRANSLATORS: Label for the custom image size when you open the media library. (Back end) */
			'theodore-full-layout-width' => esc_html__( 'Full Layout Width', 'theodore' )
		);
		return array_merge($sizes, $custom_sizes);
	}
	
	public function getCSS () {
		if ( isset( $_GET['theodore_get_file'] ) && $_GET['theodore_get_file'] == 'custom_style' ) {
			header('Content-Type: text/css');
			
			$general_settings = get_option( 'theodore_general_settings' );
			$custom_css = isset( $general_settings['custom_css'] ) 
				? $general_settings['custom_css']
				: false;
			
			if ( $custom_css ) {
				/* remove @import lines in custom_css */
				echo preg_replace( '/\s*@import.*;\s*/iU', '', $general_settings['custom_css'] );
			}
			
			die();
		}
	}
	
}

?>