<?php

/**
 * This class makes a copy and double its size of every images uploaded.
 * It also adds a custom size with id 'grid-thumb'
 */

class TheodoreThemeAttachment {
	
	public function __construct () {
		
		/* Double the dimension of attachments for retina */
		add_filter( 'wp_generate_attachment_metadata', array( $this, 'retinaSupportAttachmentMeta' ), 10, 2 );
		add_filter( 'delete_attachment', array( $this, 'deleteRetinaSupportImages' ) );
	}
	
	/**
	 * Loop through the attachment meta data to find the sizes we need to double
	 *
	 * @param mixed $metadata Array structure of image meta data
	 * @param int $attachment_id
	 */
	public function retinaSupportAttachmentMeta ( $metadata, $attachment_id ) {
		foreach ( $metadata as $key => $value ) {
			if ( is_array( $value ) ) {
				foreach ( $value as $image => $attr ) {
					if ( is_array( $attr ) && isset( $attr['width'] ) && isset( $attr['height'] ) ) {
						$this->retinaSupportCreateImages( get_attached_file( $attachment_id ), $attr['width'], $attr['height'], true );
					}
				}
			}
		}		
		return $metadata;
	}
	
	/**
	 * Double the dimension each attachment found in attachment meta data
	 *
	 * @param string $file Path to file to load
	 * @param int $width Width of the original image
	 * @param int $height Height of the original image
	 * @param bool $crop Whether to crop the image
	 */
	public function retinaSupportCreateImages ( $file, $width, $height, $crop = false ) {
		if ( $width || $height ) {
			$resized_file = wp_get_image_editor( $file );
			if ( !is_wp_error( $resized_file ) ) {
				$filename = $resized_file->generate_filename( $width . 'x' . $height . '@2x' );
				
				$resized_file->resize( $width * 2, $height * 2, $crop );
				$resized_file->save( $filename );
	 
				$info = $resized_file->get_size();
	 
				return array(
					'file' => wp_basename( $filename ),
					'width' => $info['width'],
					'height' => $info['height'],
				);
			}
		}
		return false;
	}
	
	/**
	 * When WordPress deletes image attachment, remove the copied images
	 *
	 * @param int $attachment_id
	 */
	public function deleteRetinaSupportImages ( $attachment_id ) {
		$meta = wp_get_attachment_metadata( $attachment_id );
		$upload_dir = wp_upload_dir();
		
		if ( isset( $meta['file'] ) ) {
			$path = pathinfo( $meta['file'] );
			foreach ( $meta as $key => $value ) {
				if ( 'sizes' === $key ) {
					foreach ( $value as $sizes => $size ) {
						$original_filename = $upload_dir['basedir'] . '/' . $path['dirname'] . '/' . $size['file'];
						$retina_filename = substr_replace( $original_filename, '@2x.', strrpos( $original_filename, '.' ), strlen( '.' ) );
						if ( file_exists( $retina_filename ) ) {
							unlink( $retina_filename );
						}
					}
				}
			}
		}
	}
	
}

?>